/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.formbuilder.util;

import com.arsdigita.bebop.util.Attributes;
import com.arsdigita.formbuilder.util.ExtendedElement;
import com.arsdigita.util.Assert;
import com.arsdigita.util.StringUtils;
import com.arsdigita.util.UncheckedWrapperException;
import java.io.StringReader;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.oro.text.perl.Perl5Util;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class AttributeHelper {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/formbuilder/util/AttributeHelper.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private Attributes m_attributesObject;
    private DefaultHandler m_attributeHandler = new DefaultHandler(){

        public void startElement(String uri, String localName, String qName, org.xml.sax.Attributes attributes) throws SAXException {
            for (int i = 0; i < attributes.getLength(); ++i) {
                AttributeHelper.this.m_attributesObject.setAttribute(attributes.getQName(i), attributes.getValue(i));
            }
        }
    };

    public static String getAttributeString(Attributes attributes) {
        if (attributes == null) {
            return "";
        }
        ExtendedElement componentElement = new ExtendedElement("ignore", "ignore");
        attributes.exportAttributes(componentElement);
        Perl5Util perl = new Perl5Util();
        StringBuffer attributeStringBuffer = new StringBuffer();
        Map attributeMap = componentElement.getAttributes();
        Iterator attributeNameIterator = attributeMap.keySet().iterator();
        while (attributeNameIterator.hasNext()) {
            String attributeName = (String)attributeNameIterator.next();
            String attributeValue = (String)attributeMap.get(attributeName);
            Assert.assertTrue(perl.match("/^\\w+$/", attributeName));
            attributeValue = StringUtils.quoteHtml(attributeValue);
            attributeStringBuffer.append(attributeName + "=\"" + attributeValue + "\"");
            if (!attributeNameIterator.hasNext()) continue;
            attributeStringBuffer.append(" ");
        }
        return attributeStringBuffer.toString();
    }

    public Attributes getAttributesMap(String attributeString) {
        if (attributeString == null || attributeString.equals("")) {
            return new Attributes();
        }
        String xmlString = "<dummyElement " + attributeString + " />";
        this.m_attributesObject = new Attributes();
        try {
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            SAXParser saxParser = saxParserFactory.newSAXParser();
            saxParser.parse(new InputSource(new StringReader(xmlString)), this.m_attributeHandler);
        }
        catch (Exception e) {
            throw new UncheckedWrapperException(e);
        }
        return this.m_attributesObject;
    }
}

