/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.formbuilder.ui.editors;

import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.EmailParameter;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.StringInRangeValidationListener;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.formbuilder.PersistentProcessListener;
import com.arsdigita.formbuilder.actions.SimpleEmailListener;
import com.arsdigita.formbuilder.ui.editors.ProcessListenerForm;
import com.arsdigita.formbuilder.util.GlobalizationUtil;
import java.math.BigDecimal;

public class SimpleEmailForm
extends ProcessListenerForm {
    private TextField m_to;
    private TextField m_subject;

    public SimpleEmailForm(String name, SingleSelectionModel form, SingleSelectionModel action) {
        super(name, form, action);
    }

    protected void addWidgets(FormSection section) {
        super.addWidgets(section);
        this.m_to = new TextField(new EmailParameter("to"));
        this.m_to.setSize(50);
        this.m_to.addValidationListener(new NotNullValidationListener());
        section.add(new Label(GlobalizationUtil.globalize("formbuilder.ui.editors.to")), 4);
        section.add(this.m_to);
        this.m_subject = new TextField(new StringParameter("subject"));
        this.m_subject.setSize(50);
        this.m_subject.addValidationListener(new NotNullValidationListener());
        this.m_subject.addValidationListener(new StringInRangeValidationListener(1, 120));
        section.add(new Label(GlobalizationUtil.globalize("formbuilder.ui.editors.subject")), 4);
        section.add(this.m_subject);
    }

    protected PersistentProcessListener getProcessListener() {
        return new SimpleEmailListener();
    }

    protected PersistentProcessListener getProcessListener(BigDecimal id) throws DataObjectNotFoundException {
        return new SimpleEmailListener(id);
    }

    protected void initWidgets(FormSectionEvent e, PersistentProcessListener listener) throws FormProcessException {
        super.initWidgets(e, listener);
        SimpleEmailListener l = (SimpleEmailListener)listener;
        PageState state = e.getPageState();
        if (l == null) {
            this.m_to.setValue(state, "");
            this.m_subject.setValue(state, "");
        } else {
            this.m_to.setValue(state, l.getTo());
            this.m_subject.setValue(state, l.getSubject());
        }
    }

    protected void processWidgets(FormSectionEvent e, PersistentProcessListener listener) throws FormProcessException {
        super.processWidgets(e, listener);
        SimpleEmailListener l = (SimpleEmailListener)listener;
        FormData data = e.getFormData();
        String to = data.get("to").toString();
        String subject = (String)data.get("subject");
        l.setTo(to);
        l.setSubject(subject);
    }
}

