/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.formbuilder.ui.editors;

import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.OptionGroup;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.formbuilder.PersistentOption;
import com.arsdigita.formbuilder.PersistentOptionGroup;
import com.arsdigita.formbuilder.PersistentWidget;
import com.arsdigita.formbuilder.ui.editors.WidgetLabelForm;
import com.arsdigita.formbuilder.util.GlobalizationUtil;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.xml.Element;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.TooManyListenersException;

public abstract class OptionGroupForm
extends WidgetLabelForm {
    private OptionGroup m_value;
    private Label m_value_label;
    private Iterator m_opts;
    SingleSelectionModel m_control;

    public OptionGroupForm(String name, SingleSelectionModel form, SingleSelectionModel control) {
        super(name, form, control);
        this.m_control = control;
    }

    protected void addWidgets(FormSection section) {
        super.addWidgets(section);
        this.m_value = this.getOptionGroup("value");
        this.m_value_label = new Label(GlobalizationUtil.globalize("formbuilder.ui.editors.value"));
        section.add(this.m_value_label, 4);
        section.add(this.m_value);
        try {
            this.m_value.addPrintListener(new ControlFormPrintListener());
        }
        catch (TooManyListenersException ex) {
            throw new UncheckedWrapperException("This will never happen", ex);
        }
    }

    protected abstract OptionGroup getOptionGroup(String var1);

    public void generateXML(PageState state, Element parent) {
        BigDecimal control = (BigDecimal)this.m_control.getSelectedKey(state);
        PersistentOptionGroup group = null;
        if (control != null) {
            try {
                group = (PersistentOptionGroup)this.getWidget(control);
            }
            catch (DataObjectNotFoundException ex) {
                throw new UncheckedWrapperException("cannot find persistent option group", ex);
            }
        }
        if (group != null) {
            this.m_opts = group.getOptions().iterator();
            this.m_value.setVisible(state, this.m_opts.hasNext());
            this.m_value_label.setVisible(state, this.m_opts.hasNext());
        } else {
            this.m_opts = null;
            this.m_value.setVisible(state, false);
            this.m_value_label.setVisible(state, false);
        }
        super.generateXML(state, parent);
    }

    protected void initWidgets(FormSectionEvent e, PersistentWidget w) throws FormProcessException {
        super.initWidgets(e, w);
        PageState state = e.getPageState();
    }

    protected void processWidgets(FormSectionEvent e, PersistentWidget w) throws FormProcessException {
        super.processWidgets(e, w);
    }

    private class ControlFormPrintListener
    implements PrintListener {
        private ControlFormPrintListener() {
        }

        public void prepare(PrintEvent e) {
            if (OptionGroupForm.this.m_opts == null) {
                return;
            }
            OptionGroup grp = (OptionGroup)e.getTarget();
            while (OptionGroupForm.this.m_opts.hasNext()) {
                PersistentOption o = (PersistentOption)OptionGroupForm.this.m_opts.next();
                grp.addOption(new Option(o.getParameterValue(), o.getLabel()));
            }
        }
    }
}

