/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.formbuilder.ui;

import com.arsdigita.bebop.List;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.bebop.list.ListModelBuilder;
import com.arsdigita.bebop.parameters.IntegerParameter;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.formbuilder.PersistentFormSection;
import com.arsdigita.formbuilder.PersistentProcessListener;
import com.arsdigita.util.LockableImpl;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;
import java.util.Iterator;

public class ProcessListenerListModelBuilder
extends LockableImpl
implements ListModelBuilder {
    public ListModel makeModel(List l, PageState state) {
        Integer form_id = (Integer)state.getValue(new IntegerParameter("form"));
        PersistentFormSection form = null;
        try {
            form = new PersistentFormSection(new BigDecimal((double)form_id.intValue()));
        }
        catch (DataObjectNotFoundException ex) {
            throw new UncheckedWrapperException(ex);
        }
        return new ProcessListenerListModel(form.getProcessListeners());
    }

    private class ProcessListenerListModel
    implements ListModel {
        private Iterator m_listeners;
        private PersistentProcessListener listener;

        public ProcessListenerListModel(Iterator listeners) {
            this.m_listeners = listeners;
            this.listener = null;
        }

        public boolean next() {
            if (this.m_listeners.hasNext()) {
                this.listener = (PersistentProcessListener)this.m_listeners.next();
                return true;
            }
            return false;
        }

        public Object getElement() {
            return this.listener;
        }

        public String getKey() {
            return this.listener.getID().toString();
        }
    }
}

