/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.formbuilder;

import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.form.Widget;
import com.arsdigita.bebop.parameters.IntegerParameter;
import com.arsdigita.bebop.parameters.NotEmptyValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.formbuilder.AttributeMetaData;
import com.arsdigita.formbuilder.AttributeMetaDataList;
import com.arsdigita.formbuilder.AttributeMetaDataProvider;
import com.arsdigita.formbuilder.AttributeType;
import com.arsdigita.formbuilder.PersistentComponentFactory;
import com.arsdigita.formbuilder.util.FormBuilderUtil;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class FormSectionGenerator {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/formbuilder/FormSectionGenerator.java#10 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((String)(class$com$arsdigita$formbuilder$FormSectionGenerator == null ? (class$com$arsdigita$formbuilder$FormSectionGenerator = FormSectionGenerator.class$("com.arsdigita.formbuilder.FormSectionGenerator")) : class$com$arsdigita$formbuilder$FormSectionGenerator).getName());
    private AttributeMetaDataProvider m_metaDataProvider;
    private boolean m_isAdd = true;
    static /* synthetic */ Class class$com$arsdigita$formbuilder$FormSectionGenerator;

    public FormSectionGenerator(AttributeMetaDataProvider metaDataProvider) {
        this.m_metaDataProvider = metaDataProvider;
    }

    public FormSection generateFormSection() {
        return this.generateFormSection(true, true);
    }

    public FormSection generateFormSection(boolean addProcessListener, boolean isAdd) {
        FormSection formSection = new FormSection();
        this.m_isAdd = isAdd;
        AttributeMetaDataList attributeList = this.m_metaDataProvider.getAttributeMetaData();
        attributeList.setIteratorAtStart();
        while (attributeList.hasNext()) {
            String labelText;
            AttributeMetaData attribute = attributeList.next();
            String parameterName = attribute.getParameterName();
            String label = attribute.getLabel();
            boolean isRequired = attribute.isRequired();
            AttributeType attributeType = attribute.getAttributeType();
            String string = labelText = label == null ? parameterName : label;
            if (isRequired) {
                labelText = labelText + " (required) ";
            }
            formSection.add(new Label(labelText));
            ParameterModel parameterModel = attribute.getParameterModel();
            if (parameterModel == null) {
                parameterModel = this.getModelFromReflection(parameterName);
            }
            TextField textField = new TextField(parameterModel);
            if (isRequired) {
                textField.addValidationListener(new NotEmptyValidationListener());
            }
            if (attributeType != null) {
                this.addValidationListeners(textField, attributeType.getValidationListeners());
            }
            this.setDefaultValue(textField, parameterName);
            formSection.add(textField);
        }
        if (addProcessListener) {
            formSection.addProcessListener(this.getSetProcessListener());
            Class domainObjectClass = FormBuilderUtil.loadClass("com.arsdigita.domain.DomainObject");
            if (domainObjectClass.isAssignableFrom(this.m_metaDataProvider.getClass()) || this.m_metaDataProvider instanceof PersistentComponentFactory) {
                formSection.addProcessListener(this.getDomainObjectSaveListener());
            }
        }
        return formSection;
    }

    public FormProcessListener getSetProcessListener() {
        return new FormProcessListener(){

            public void process(FormSectionEvent event) {
                FormData formData = event.getFormData();
                AttributeMetaDataList attributeList = FormSectionGenerator.this.m_metaDataProvider.getAttributeMetaData();
                attributeList.setIteratorAtStart();
                while (attributeList.hasNext()) {
                    Method setMethod;
                    AttributeMetaData attribute = attributeList.next();
                    String parameterName = attribute.getParameterName();
                    Object parameterValue = formData.get(parameterName);
                    if (parameterValue == null || parameterValue.toString().trim().equals("") || (setMethod = FormSectionGenerator.this.getParameterMethod(parameterName, true)) == null) continue;
                    try {
                        FormBuilderUtil.invokeMethod(setMethod, FormSectionGenerator.this.m_metaDataProvider, new Object[]{parameterValue});
                    }
                    catch (IllegalArgumentException e) {}
                }
            }
        };
    }

    private void setDefaultValue(Widget widget, String parameterName) {
        Method getMethod = this.getParameterMethod(parameterName, false);
        Object defaultValue = FormBuilderUtil.invokeMethod(getMethod, this.m_metaDataProvider, new Object[0]);
        if (defaultValue != null) {
            widget.setDefaultValue(defaultValue);
        }
    }

    private ParameterModel getModelFromReflection(String parameterName) {
        Method parameterMethod = this.getParameterMethod(parameterName, true);
        Class<?>[] parameterTypes = parameterMethod.getParameterTypes();
        String typeName = parameterTypes[0].getName();
        if (typeName.equals("int")) {
            return new IntegerParameter(parameterName);
        }
        if (typeName.equals("java.lang.String") || typeName.equals("java.lang.Object")) {
            return new StringParameter(parameterName);
        }
        throw new IllegalStateException("Trying to generate a Form with an attribute of type " + typeName + ". This type is currently not supported");
    }

    private Method getParameterMethod(String parameterName, boolean isSet) {
        Method returnMethod = null;
        Method[] methods = this.m_metaDataProvider.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            String methodPrefix = "";
            methodPrefix = isSet ? "set" : "get";
            String setMethodName = methodPrefix + parameterName.substring(0, 1).toUpperCase() + parameterName.substring(1);
            if (!method.getName().equals(setMethodName)) continue;
            returnMethod = method;
            break;
        }
        return returnMethod;
    }

    private FormProcessListener getDomainObjectSaveListener() {
        return new FormProcessListener(){

            public void process(FormSectionEvent event) {
                if (FormSectionGenerator.this.m_metaDataProvider instanceof DomainObject) {
                    ((DomainObject)((Object)FormSectionGenerator.this.m_metaDataProvider)).save();
                } else {
                    ((PersistentComponentFactory)((Object)FormSectionGenerator.this.m_metaDataProvider)).save();
                }
            }
        };
    }

    private void addValidationListeners(Widget widget, List validationListeners) {
        Iterator validationIter = validationListeners.iterator();
        while (validationIter.hasNext()) {
            widget.addValidationListener((ParameterListener)validationIter.next());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

