/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.domain;

import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectTraversal;
import com.arsdigita.domain.DomainObjectTraversalAdapter;
import com.arsdigita.domain.DomainObjectXMLFormatter;
import com.arsdigita.persistence.metadata.MetadataRoot;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.persistence.metadata.Property;
import com.arsdigita.xml.Element;
import com.arsdigita.xml.XML;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.log4j.Logger;

public class DomainObjectXMLRenderer
extends DomainObjectTraversal {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$domain$DomainObjectXMLRenderer == null ? (class$com$arsdigita$domain$DomainObjectXMLRenderer = DomainObjectXMLRenderer.class$("com.arsdigita.domain.DomainObjectXMLRenderer")) : class$com$arsdigita$domain$DomainObjectXMLRenderer));
    private static Map s_formatters = new HashMap();
    private Stack m_elements = new Stack();
    private Element m_element;
    private boolean m_wrapRoot = false;
    private boolean m_wrapObjects = false;
    private boolean m_wrapAttributes = false;
    private boolean m_revisitFullObject = false;
    private Map m_objectElements;
    private String m_namespaceURI;
    private String m_namespacePrefix;
    private DomainObjectXMLFormatter m_formatter;
    static /* synthetic */ Class class$com$arsdigita$domain$DomainObjectXMLRenderer;

    public static void registerFormatter(ObjectType type, DomainObjectXMLFormatter formatter, String context) {
        s_formatters.put(new DomainObjectTraversal.AdapterKey(type, context), formatter);
    }

    public static void unregisterFormatter(ObjectType type, String context) {
        s_formatters.remove(new DomainObjectTraversal.AdapterKey(type, context));
    }

    public static void registerFormatter(String type, DomainObjectXMLFormatter formatter, String context) {
        DomainObjectXMLRenderer.registerFormatter(MetadataRoot.getMetadataRoot().getObjectType(type), formatter, context);
    }

    public static void unregisterFormatter(String type, String context) {
        DomainObjectXMLRenderer.unregisterFormatter(MetadataRoot.getMetadataRoot().getObjectType(type), context);
    }

    public static DomainObjectXMLFormatter getFormatter(ObjectType type, String context) {
        return (DomainObjectXMLFormatter)s_formatters.get(new DomainObjectTraversal.AdapterKey(type, context));
    }

    public static DomainObjectXMLFormatter findFormatter(ObjectType type, String context) {
        DomainObjectXMLFormatter formatter = null;
        while (formatter == null && type != null) {
            formatter = DomainObjectXMLRenderer.getFormatter(type, context);
            type = type.getSupertype();
        }
        return formatter;
    }

    public DomainObjectXMLRenderer(Element root) {
        this.m_element = root;
        this.m_objectElements = new HashMap();
    }

    public void setNamespace(String prefix, String uri) {
        this.m_namespacePrefix = prefix;
        this.m_namespaceURI = uri;
    }

    protected String format(DomainObject obj, String path, Property prop, Object value) {
        if (this.m_formatter != null) {
            return this.m_formatter.format(obj, this.appendToPath(path, prop.getName()), prop, value);
        }
        return XML.format(value);
    }

    protected void walk(DomainObject obj, String context, DomainObjectTraversalAdapter adapter) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Traversing " + obj + " for context " + context + " " + "using adapter " + adapter));
        }
        this.m_formatter = DomainObjectXMLRenderer.findFormatter(obj.getObjectType(), context);
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Found formatter " + this.m_formatter));
        }
        super.walk(obj, context, adapter);
    }

    public void setWrapRoot(boolean value) {
        this.m_wrapRoot = value;
    }

    public void setWrapObjects(boolean value) {
        this.m_wrapObjects = value;
    }

    public void setWrapAttributes(boolean value) {
        this.m_wrapAttributes = value;
    }

    public void setRevisitFullObject(boolean value) {
        this.m_revisitFullObject = value;
    }

    public boolean isWrappingAttributes() {
        return this.m_wrapAttributes;
    }

    public boolean isWrappingObjects() {
        return this.m_wrapObjects;
    }

    public boolean isWrappingRoot() {
        return this.m_wrapRoot;
    }

    protected void beginObject(DomainObject obj, String path) {
        if (this.m_wrapRoot || !path.equals("/object")) {
            String name = this.m_wrapObjects ? "object" : this.nameFromPath(path);
            Element element = this.newElement(this.m_element, name);
            this.m_elements.push(this.m_element);
            this.m_element = element;
        }
        this.m_element.addAttribute("oid", obj.getOID().toString());
        if (this.m_revisitFullObject) {
            this.m_objectElements.put(obj.getOID(), this.m_element);
        }
    }

    protected void endObject(DomainObject obj, String path) {
        if (this.m_wrapRoot || !path.equals("/object")) {
            this.m_element = (Element)this.m_elements.pop();
        }
    }

    protected void revisitObject(DomainObject obj, String path) {
        Element priorElement = null;
        if (this.m_revisitFullObject) {
            priorElement = (Element)this.m_objectElements.get(obj.getOID());
        }
        if (priorElement != null && this.m_elements.search(priorElement) == -1) {
            String name = this.m_wrapObjects ? "object" : this.nameFromPath(path);
            Element element = this.newElement(this.m_element, name, priorElement);
        } else {
            String name = this.m_wrapObjects ? "object" : this.nameFromPath(path);
            Element element = this.newElement(this.m_element, name);
            element.addAttribute("oid", obj.getOID().toString());
        }
    }

    protected void handleAttribute(DomainObject obj, String path, Property property) {
        String name = property.getName();
        Object value = obj.get(name);
        if (value != null) {
            if (this.m_wrapAttributes) {
                Element element = this.newElement(this.m_element, name);
                element.setText(this.format(obj, path, property, value));
            } else {
                this.m_element.addAttribute(property.getName(), this.format(obj, path, property, value));
            }
        }
    }

    protected void beginRole(DomainObject obj, String path, Property property) {
        if (this.m_wrapObjects) {
            Element element = this.newElement(this.m_element, property.getName());
            this.m_elements.push(this.m_element);
            this.m_element = element;
        }
    }

    protected void endRole(DomainObject obj, String path, Property property) {
        if (this.m_wrapObjects) {
            this.m_element = (Element)this.m_elements.pop();
        }
    }

    protected void beginAssociation(DomainObject obj, String path, Property property) {
        if (this.m_wrapObjects) {
            Element element = this.newElement(this.m_element, property.getName());
            this.m_elements.push(this.m_element);
            this.m_element = element;
        }
    }

    protected void endAssociation(DomainObject obj, String path, Property property) {
        if (this.m_wrapObjects) {
            this.m_element = (Element)this.m_elements.pop();
        }
    }

    protected Element getCurrentElement() {
        return this.m_element;
    }

    protected Element newElement(Element parent, String name) {
        return this.m_namespaceURI == null ? parent.newChildElement(name) : parent.newChildElement(this.m_namespacePrefix + ":" + name, this.m_namespaceURI);
    }

    protected Element newElement(Element parent, String name, Element copy) {
        return this.m_namespaceURI == null ? parent.newChildElement(name, copy) : parent.newChildElement(this.m_namespacePrefix + ":" + name, this.m_namespaceURI, copy);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

