/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.domain;

import com.arsdigita.domain.AbstractDomainObjectObserver;
import com.arsdigita.domain.DeleteException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.ObservableDomainObject;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataAssociationCursor;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.PersistenceException;
import com.arsdigita.persistence.metadata.Property;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class DeleteCheckObserver
extends AbstractDomainObjectObserver {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$domain$DeleteCheckObserver == null ? (class$com$arsdigita$domain$DeleteCheckObserver = DeleteCheckObserver.class$("com.arsdigita.domain.DeleteCheckObserver")) : class$com$arsdigita$domain$DeleteCheckObserver));
    private static final DeleteCheckObserver s_observer = new DeleteCheckObserver();
    static /* synthetic */ Class class$com$arsdigita$domain$DeleteCheckObserver;

    private DeleteCheckObserver() {
    }

    public static final void observe(ObservableDomainObject obj) {
        obj.addObserver(s_observer);
    }

    public void beforeDelete(DomainObject obj) throws PersistenceException {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Checking delete of " + obj.getOID()));
        }
        DeleteException ex = new DeleteException(obj);
        DataObject dObj = obj.getDataObject();
        boolean error = false;
        Iterator properties = dObj.getObjectType().getProperties();
        while (properties.hasNext()) {
            Object assocObj;
            Property assocProp;
            Property property = (Property)properties.next();
            String propName = property.getName();
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Checking property " + propName));
            }
            if (property.isComponent() || null == (assocProp = property.getAssociatedProperty()) || !assocProp.isRequired()) continue;
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)(propName + " would cause failure"));
            }
            if ((assocObj = dObj.get(property.getName())) instanceof DataAssociation) {
                DataAssociation assoc = (DataAssociation)assocObj;
                DataAssociationCursor cursor = assoc.cursor();
                while (cursor.next()) {
                    error = true;
                    ex.addDependency(propName, cursor.getDataObject());
                    if (!s_log.isDebugEnabled()) continue;
                    s_log.debug((Object)("Dependent object " + cursor.getDataObject().getOID()));
                }
                continue;
            }
            if (null == assocObj) continue;
            error = true;
            DataObject assocDObj = (DataObject)assocObj;
            ex.addDependency(propName, assocDObj);
            if (!s_log.isDebugEnabled()) continue;
            s_log.debug((Object)("Dependent object " + assocDObj.getOID()));
        }
        if (error) {
            throw ex;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

