/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.dmi;

import com.arsdigita.db.ConnectionManager;
import com.arsdigita.db.DbHelper;
import com.arsdigita.db.Sequences;
import com.arsdigita.dmi.DataModelInitializer;
import com.arsdigita.dmi.Product;
import com.arsdigita.installer.LoadSQLPlusScript;
import com.arsdigita.installer.ParseException;
import java.io.FileNotFoundException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class ProductVersion {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/dmi/ProductVersion.java#11 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$dmi$ProductVersion == null ? (class$com$arsdigita$dmi$ProductVersion = ProductVersion.class$("com.arsdigita.dmi.ProductVersion")) : class$com$arsdigita$dmi$ProductVersion));
    private Product m_product = null;
    private BigDecimal m_ID = null;
    private String m_sName = null;
    private Date m_creationDate = null;
    private String m_sFileName = null;
    private String m_sErrors = null;
    private String m_sDesc = null;
    private static HashMap s_queries = null;
    static /* synthetic */ Class class$com$arsdigita$dmi$ProductVersion;

    public ProductVersion() {
    }

    public ProductVersion(BigDecimal versionID, Product p) throws SQLException {
        Connection conn = ConnectionManager.getConnection();
        PreparedStatement pstmt = conn.prepareStatement(ProductVersion.lookupQuery("getProductVersionByIDSQL"));
        pstmt.setBigDecimal(1, versionID);
        pstmt.setBigDecimal(2, p.getID());
        ResultSet rset = pstmt.executeQuery();
        if (!rset.next()) {
            throw new SQLException("Query did not return any rows");
        }
        this.m_product = p;
        this.m_sName = rset.getString(1);
        this.m_creationDate = rset.getDate(2);
        this.m_sFileName = rset.getString(3);
        this.m_sErrors = rset.getString(4);
        this.m_sDesc = rset.getString(5);
        this.m_ID = versionID;
        rset.close();
        pstmt.close();
    }

    public ProductVersion(String sName, Product p) throws SQLException {
        Connection conn = ConnectionManager.getConnection();
        PreparedStatement pstmt = conn.prepareStatement(ProductVersion.lookupQuery("getProductVersionByNameSQL"));
        pstmt.setString(1, sName.toUpperCase());
        pstmt.setBigDecimal(2, p.getID());
        ResultSet rset = pstmt.executeQuery();
        if (!rset.next()) {
            throw new SQLException("Query did not return any rows");
        }
        this.m_product = p;
        this.m_ID = rset.getBigDecimal(1);
        this.m_creationDate = rset.getDate(2);
        this.m_sFileName = rset.getString(3);
        this.m_sErrors = rset.getString(4);
        this.m_sDesc = rset.getString(5);
        this.m_sName = sName;
        rset.close();
        pstmt.close();
    }

    public static ProductVersion createProductVersion(Product p, String sName, String sInstallFile, String sDesc) throws SQLException, IllegalStateException {
        ProductVersion pv = new ProductVersion();
        pv.setProduct(p);
        pv.setName(sName);
        pv.setInstallFileName(sInstallFile);
        pv.setDescription(sDesc);
        pv.save();
        return pv;
    }

    private void setProduct(Product p) {
        this.m_product = p;
    }

    public Product getProduct() {
        return this.m_product;
    }

    public BigDecimal getID() {
        return this.m_ID;
    }

    public String getName() {
        return this.m_sName;
    }

    public void setName(String sName) {
        this.m_sName = sName;
    }

    public Date getCreationDate() {
        return this.m_creationDate;
    }

    public String getInstallFileName() {
        return this.m_sFileName;
    }

    private void setInstallFileName(String sFileName) {
        this.m_sFileName = sFileName;
    }

    public String getInstallErrors() {
        return this.m_sErrors;
    }

    public String getDesc() {
        return this.m_sDesc;
    }

    public void setDescription(String sDesc) {
        this.m_sDesc = sDesc;
    }

    public ProductVersion getPreviousVersion() throws SQLException {
        Connection conn = ConnectionManager.getConnection();
        PreparedStatement pstmt = conn.prepareStatement(ProductVersion.lookupQuery("getPreviousVersionSQL"));
        pstmt.setBigDecimal(1, this.m_ID);
        ResultSet rset = pstmt.executeQuery();
        if (!rset.next()) {
            return null;
        }
        BigDecimal prev_ID = rset.getBigDecimal(1);
        return new ProductVersion(prev_ID, this.m_product);
    }

    private void installProductVersionDM() throws ClassNotFoundException, SQLException, ParseException, FileNotFoundException, IllegalAccessException, NoSuchMethodException {
        Connection conn = ConnectionManager.getConnection();
        LoadSQLPlusScript ls = new LoadSQLPlusScript();
        ls.setConnection(conn);
        ls.loadSQLPlusScript(this.m_sFileName);
    }

    public BigDecimal getLatestProductVersionID() throws SQLException {
        Connection conn = ConnectionManager.getConnection();
        PreparedStatement pstmt = conn.prepareStatement(ProductVersion.lookupQuery("getLatestProductVersionSQL"));
        pstmt.setBigDecimal(1, this.m_product.getID());
        pstmt.setBigDecimal(2, this.m_product.getID());
        ResultSet rset = pstmt.executeQuery();
        if (!rset.next()) {
            return null;
        }
        return rset.getBigDecimal(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BigDecimal insertProductVersion() throws SQLException {
        BigDecimal ID;
        PreparedStatement pstmt;
        block10: {
            block11: {
                Connection conn = ConnectionManager.getConnection();
                BigDecimal prevID = this.getLatestProductVersionID();
                pstmt = conn.prepareStatement(ProductVersion.lookupQuery("insertProductVersionSQL"));
                ID = Sequences.getNextValue(DataModelInitializer.SEQUENCE_NAME);
                pstmt.setBigDecimal(1, ID);
                pstmt.setBigDecimal(2, this.m_product.getID());
                pstmt.setString(3, this.m_sName);
                pstmt.setString(4, this.m_sFileName);
                pstmt.setString(6, this.m_sDesc);
                if (prevID == null) {
                    pstmt.setNull(7, 4);
                } else {
                    pstmt.setBigDecimal(7, prevID);
                }
                this.m_sErrors = null;
                try {
                    try {
                        this.installProductVersionDM();
                    }
                    catch (Exception e) {
                        this.m_sErrors = e.getMessage();
                        s_log.error((Object)("ERROR LOADING DATA MODEL: " + this.m_sErrors));
                        if (this.m_sErrors == null || this.m_sErrors.length() == 0) {
                            this.m_sErrors = "Error loading data model.  No message provided.";
                        }
                        Object var7_6 = null;
                        if (this.m_sErrors != null) {
                            pstmt.setString(5, this.m_sErrors);
                            break block10;
                        } else {
                            pstmt.setNull(5, 12);
                        }
                        break block10;
                    }
                    Object var7_5 = null;
                    if (this.m_sErrors == null) break block11;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    if (this.m_sErrors != null) {
                        pstmt.setString(5, this.m_sErrors);
                        throw throwable;
                    }
                    pstmt.setNull(5, 12);
                    throw throwable;
                }
                pstmt.setString(5, this.m_sErrors);
                break block10;
            }
            pstmt.setNull(5, 12);
        }
        pstmt.executeUpdate();
        pstmt.close();
        return ID;
    }

    private int updateProductVersion() throws SQLException {
        Connection conn = ConnectionManager.getConnection();
        PreparedStatement pstmt = conn.prepareStatement(ProductVersion.lookupQuery("updateProductVersionSQL"));
        pstmt.setString(1, this.m_sName);
        pstmt.setString(2, this.m_sFileName);
        pstmt.setString(3, this.m_sDesc);
        pstmt.setBigDecimal(4, this.m_ID);
        int iReturn = pstmt.executeUpdate();
        pstmt.close();
        return iReturn;
    }

    public void save() throws SQLException, IllegalStateException {
        Connection conn = ConnectionManager.getConnection();
        if (this.m_product == null) {
            throw new IllegalStateException("Cannot save this ProductVersion because it has no Product set.");
        }
        boolean bAutoCommit = conn.getAutoCommit();
        if (bAutoCommit) {
            conn.setAutoCommit(false);
        }
        if (this.m_ID == null) {
            this.m_ID = this.insertProductVersion();
            PreparedStatement pstmt = conn.prepareStatement(ProductVersion.lookupQuery("getProductVersionCreationDateSQL"));
            pstmt.setBigDecimal(1, this.m_ID);
            ResultSet rset = pstmt.executeQuery();
            rset.next();
            this.m_creationDate = rset.getDate(1);
            rset.close();
            pstmt.close();
        } else {
            this.updateProductVersion();
        }
        if (bAutoCommit) {
            conn.commit();
        }
    }

    private static String lookupQuery(String queryName) {
        Object dbDefaultValue;
        Object dbSpecificValue;
        HashMap queries = (HashMap)s_queries.get(new Integer(DbHelper.getDatabase()));
        if (queries != null && (dbSpecificValue = queries.get(queryName)) != null) {
            s_log.warn((Object)("Query specific lookup - key: " + queryName + " value: " + dbSpecificValue.toString()));
            return dbSpecificValue.toString();
        }
        queries = (HashMap)s_queries.get(new Integer(0));
        if (queries != null && (dbDefaultValue = queries.get(queryName)) != null) {
            s_log.warn((Object)("Query default lookup - key: " + queryName + " value: " + dbDefaultValue.toString()));
            return dbDefaultValue.toString();
        }
        s_log.warn((Object)("Query lookup failed for key: " + queryName));
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        s_queries = new HashMap();
        HashMap<String, String> defaultdb = new HashMap<String, String>();
        defaultdb.put("getProductVersionByIDSQL", "select version_name, creation_date, install_file, install_errors, description from dmi_product_versions where version_id = ? and product_id = ?");
        defaultdb.put("getProductVersionByNameSQL", "select version_id, creation_date, install_file, install_errors, description from dmi_product_versions where upper(version_name) = ? and product_id = ?");
        defaultdb.put("updateProductVersionSQL", "update dmi_product+versions set version_name = ?, install_file = ?, description = ? where version_id = ?");
        defaultdb.put("getProductVersionCreationDateSQL", "select creation_date from dmi_product_versions where version_id = ?");
        defaultdb.put("getPreviousVersionSQL", "select previous_version_id from dmi_product_versions where version_id = ?");
        defaultdb.put("getLatestProductVersionSQL", "select version_id from dmi_product_versions where product_id = ? minus select previous_version_id from dmi_product_versions where product_id = ?");
        HashMap<String, String> oracle = new HashMap<String, String>();
        oracle.put("insertProductVersionSQL", "insert into dmi_product_versions (version_id, product_id, version_name, creation_date, install_file, install_errors, description, previous_version_id) values (?, ?, ?, sysdate, ?, ?, ?, ?)");
        HashMap<String, String> postgres = new HashMap<String, String>();
        postgres.put("insertProductVersionSQL", "insert into dmi_product_versions (version_id, product_id, version_name, creation_date, install_file, install_errors, description, previous_version_id) values (?, ?, ?, current_timestamp(), ?, ?, ?, ?)");
        s_queries.put(new Integer(0), defaultdb);
        s_queries.put(new Integer(1), oracle);
        s_queries.put(new Integer(2), postgres);
    }
}

