/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.categorization;

import com.arsdigita.categorization.Category;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataAssociationCursor;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.util.Assert;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class CategoryPurpose
extends ACSObject {
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.categorization.CategoryPurpose";
    private static final String BASE_DATA_OBJECT_PACKAGE = "com.arsdigita.categorization";
    public static final String KEY = "key";
    public static final String NAME = "name";
    public static final String DESCRIPTION = "description";
    public static final String CATEGORIES = "purposeCategories";
    public static final String NAVIGATION = "navigation";
    public static final String ADVANCED_SEARCH = "advancedSearch";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$categorization$CategoryPurpose == null ? (class$com$arsdigita$categorization$CategoryPurpose = CategoryPurpose.class$("com.arsdigita.categorization.CategoryPurpose")) : class$com$arsdigita$categorization$CategoryPurpose));
    static /* synthetic */ Class class$com$arsdigita$categorization$CategoryPurpose;

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public static String getBaseDataObjectPackage() {
        return BASE_DATA_OBJECT_PACKAGE;
    }

    public static void setupCategoryPurposes() {
        CategoryPurpose purpose;
        if (!CategoryPurpose.purposeExists(NAVIGATION)) {
            purpose = new CategoryPurpose(NAVIGATION, "Navigation");
            purpose.save();
        }
        if (!CategoryPurpose.purposeExists(ADVANCED_SEARCH)) {
            purpose = new CategoryPurpose(ADVANCED_SEARCH, "Advanced Search");
            purpose.save();
        }
    }

    public static boolean purposeExists(String key) {
        Session ssn = SessionManager.getSession();
        DataCollection purposes = ssn.retrieve(BASE_DATA_OBJECT_TYPE);
        Filter keyFilter = purposes.addFilter("key = :key");
        keyFilter.set(KEY, key);
        boolean exists = purposes.next();
        if (exists) {
            purposes.close();
        }
        return exists;
    }

    public static CategoryPurpose getPurpose(String key) {
        Session ssn = SessionManager.getSession();
        DataCollection purposes = ssn.retrieve(BASE_DATA_OBJECT_TYPE);
        Filter keyFilter = purposes.addFilter("key = :key");
        keyFilter.set(KEY, key);
        boolean exists = purposes.next();
        CategoryPurpose thePurpose = null;
        if (exists) {
            thePurpose = new CategoryPurpose(purposes.getDataObject());
            purposes.close();
        }
        return thePurpose;
    }

    public CategoryPurpose(DataObject categoryPurposeObjectData) {
        super(categoryPurposeObjectData);
    }

    public CategoryPurpose() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    public CategoryPurpose(String typeName) {
        super(typeName);
    }

    public CategoryPurpose(ObjectType type) {
        super(type);
    }

    public CategoryPurpose(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public CategoryPurpose(String key, String name, String description) {
        this();
        this.setKey(key);
        this.setName(name);
        this.setDescription(description);
    }

    public CategoryPurpose(String key, String name) {
        this();
        this.setKey(key);
        this.setName(name);
    }

    public String getKey() {
        return (String)this.get(KEY);
    }

    public void setKey(String value) {
        this.set(KEY, value);
    }

    public String getName() {
        return (String)this.get(NAME);
    }

    public void setName(String value) {
        this.set(NAME, value);
    }

    public String getDescription() {
        return (String)this.get(DESCRIPTION);
    }

    public void setDescription(String value) {
        this.set(DESCRIPTION, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getCategories() {
        DataAssociationCursor categoryCur = ((DataAssociation)this.get(CATEGORIES)).cursor();
        try {
            categoryCur.addOrder("name asc");
            LinkedList<Category> categories = new LinkedList<Category>();
            while (categoryCur.next()) {
                Category category = (Category)DomainObjectFactory.newInstance(categoryCur.getDataObject());
                categories.add(category);
            }
            LinkedList<Category> linkedList = categories;
            return linkedList;
        }
        finally {
            categoryCur.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection getAllPurposes() {
        Session ssn = SessionManager.getSession();
        DataCollection allPurposes = ssn.retrieve(BASE_DATA_OBJECT_TYPE);
        try {
            allPurposes.addOrder("name asc");
            LinkedList<CategoryPurpose> purposes = new LinkedList<CategoryPurpose>();
            while (allPurposes.next()) {
                CategoryPurpose purpose = (CategoryPurpose)DomainObjectFactory.newInstance(allPurposes.getDataObject());
                purposes.add(purpose);
            }
            LinkedList<CategoryPurpose> linkedList = purposes;
            return linkedList;
        }
        finally {
            allPurposes.close();
        }
    }

    public static Category getRootCategory(String key) {
        Assert.assertTrue(CategoryPurpose.purposeExists(key));
        Session ssn = SessionManager.getSession();
        DataCollection allPurposes = ssn.retrieve(BASE_DATA_OBJECT_TYPE);
        Filter keyFilter = allPurposes.addFilter("key = :key");
        keyFilter.set(KEY, key);
        Assert.assertTrue(allPurposes.next());
        CategoryPurpose purpose = (CategoryPurpose)DomainObjectFactory.newInstance(allPurposes.getDataObject());
        Assert.assertTrue(!allPurposes.next());
        Collection categories = purpose.getCategories();
        Assert.assertTrue(!categories.isEmpty(), "Categories collection is empty");
        Iterator categoriesIterator = categories.iterator();
        Assert.assertTrue(categoriesIterator.hasNext(), "can't find core categories");
        do {
            Category category;
            if (!(category = (Category)categoriesIterator.next()).isRoot()) continue;
            return category;
        } while (categoriesIterator.hasNext());
        throw new RuntimeException("couldn't find root category for purpose " + key);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

