/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop.table;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.EventListenerList;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.event.TableActionListener;
import com.arsdigita.bebop.table.DefaultTableCellRenderer;
import com.arsdigita.bebop.table.DefaultTableColumnModel;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableColumn;
import com.arsdigita.bebop.table.TableColumnModel;
import com.arsdigita.util.Assert;
import com.arsdigita.xml.Element;
import java.util.Iterator;
import javax.servlet.ServletException;

public class TableHeader
extends SimpleComponent {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/table/TableHeader.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    public static final String HEAD_EVENT = "head";
    private TableCellRenderer m_defaultRenderer;
    private TableColumnModel m_columnModel;
    private Table m_table;
    private EventListenerList m_listeners;
    static /* synthetic */ Class class$com$arsdigita$bebop$event$TableActionListener;

    public TableHeader() {
        this(new DefaultTableColumnModel());
    }

    public TableHeader(TableColumnModel model) {
        this.m_columnModel = model;
        this.m_defaultRenderer = new DefaultTableCellRenderer();
        this.m_listeners = new EventListenerList();
    }

    public void addTableActionListener(TableActionListener l) {
        Assert.assertNotLocked(this);
        this.m_listeners.add(class$com$arsdigita$bebop$event$TableActionListener == null ? (class$com$arsdigita$bebop$event$TableActionListener = TableHeader.class$("com.arsdigita.bebop.event.TableActionListener")) : class$com$arsdigita$bebop$event$TableActionListener, l);
    }

    public void removeTableActionListener(TableActionListener l) {
        Assert.assertNotLocked(this);
        this.m_listeners.remove(class$com$arsdigita$bebop$event$TableActionListener == null ? (class$com$arsdigita$bebop$event$TableActionListener = TableHeader.class$("com.arsdigita.bebop.event.TableActionListener")) : class$com$arsdigita$bebop$event$TableActionListener, l);
    }

    protected void fireHeadSelected(PageState state, Object rowKey, Integer column) {
        Iterator i = this.m_listeners.getListenerIterator(class$com$arsdigita$bebop$event$TableActionListener == null ? (class$com$arsdigita$bebop$event$TableActionListener = TableHeader.class$("com.arsdigita.bebop.event.TableActionListener")) : class$com$arsdigita$bebop$event$TableActionListener);
        TableActionEvent e = null;
        while (i.hasNext()) {
            if (e == null) {
                e = new TableActionEvent(this, state, rowKey, column);
            }
            ((TableActionListener)i.next()).headSelected(e);
        }
    }

    public void respond(PageState s) throws ServletException {
        String event = s.getControlEventName();
        if (!HEAD_EVENT.equals(event)) {
            throw new ServletException("Unknown event '" + event + "'");
        }
        String value = s.getControlEventValue();
        Integer col = new Integer(value);
        this.getColumnModel().getSelectionModel().setSelectedKey(s, col);
        this.fireHeadSelected(s, null, col);
    }

    public final Table getTable() {
        return this.m_table;
    }

    public void setTable(Table v) {
        Assert.assertNotLocked(this);
        this.m_table = v;
    }

    public final TableColumnModel getColumnModel() {
        return this.m_columnModel;
    }

    public void setColumnModel(TableColumnModel v) {
        Assert.assertNotLocked(this);
        this.m_columnModel = v;
    }

    public final TableCellRenderer getDefaultRenderer() {
        return this.m_defaultRenderer;
    }

    public void setDefaultRenderer(TableCellRenderer v) {
        Assert.assertNotLocked(this);
        this.m_defaultRenderer = v;
    }

    public void generateXML(PageState s, Element p) {
        if (this.isVisible(s)) {
            Element thead = p.newChildElement("bebop:thead", "http://www.arsdigita.com/bebop/1.0");
            this.exportAttributes(thead);
            for (int i = 0; i < this.m_columnModel.size(); ++i) {
                boolean tableIsRegisteredWithPage;
                TableColumn t = this.m_columnModel.get(i);
                if (!t.isVisible(s)) continue;
                TableCellRenderer r = t.getHeaderRenderer();
                if (r == null) {
                    r = this.getDefaultRenderer();
                }
                boolean isSel = this.isSelected(s, t.getHeaderKey(), i);
                Component c = r.getComponent(this.getTable(), s, t.getHeaderValue(), isSel, t.getHeaderKey(), -1, i);
                if (c == null) continue;
                Element cell = thead.newChildElement("bebop:cell", "http://www.arsdigita.com/bebop/1.0");
                t.exportHeadAttributes(cell);
                if (isSel) {
                    cell.addAttribute("selected", "1");
                }
                if (tableIsRegisteredWithPage = s.getPage().stateContains(this.getControler())) {
                    s.setControlEvent(this.getControler(), HEAD_EVENT, String.valueOf(i));
                }
                c.generateXML(s, cell);
                if (!tableIsRegisteredWithPage) continue;
                s.clearControlEvent();
            }
        }
    }

    protected Component getControler() {
        return this;
    }

    protected boolean isSelected(PageState s, Object key, int column) {
        Object sel = this.getTable().getColumnSelectionModel().getSelectedKey(s);
        if (sel == null) {
            return false;
        }
        return column == (Integer)sel;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

