/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop.form;

import com.arsdigita.bebop.BlockStylable;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormModel;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.EventListenerList;
import com.arsdigita.bebop.event.ParameterEvent;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.parameters.ParameterData;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.bebop.util.BebopConstants;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.util.Assert;
import com.arsdigita.xml.Element;
import java.util.Collections;
import java.util.Iterator;
import java.util.TooManyListenersException;
import javax.servlet.ServletException;
import org.apache.log4j.Logger;

public abstract class Widget
extends BlockStylable
implements Cloneable,
BebopConstants {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/form/Widget.java#13 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$bebop$form$Widget == null ? (class$com$arsdigita$bebop$form$Widget = Widget.class$("com.arsdigita.bebop.form.Widget")) : class$com$arsdigita$bebop$form$Widget));
    private ParameterModel m_parameterModel;
    private EventListenerList m_listeners = new EventListenerList();
    private ParameterListener m_forwardParameter = null;
    private PrintListener m_printListener;
    private Form m_form;
    private ValidationGuard m_guard = null;
    private boolean m_validateInvisible = true;
    static final String ON_FOCUS = "onFocus";
    static final String ON_BLUR = "onBlur";
    static final String ON_SELECT = "onSelect";
    static final String ON_CHANGE = "onChange";
    static final String ON_KEY_UP = "onKeyUp";
    static /* synthetic */ Class class$com$arsdigita$bebop$form$Widget;
    static /* synthetic */ Class class$com$arsdigita$bebop$parameters$ParameterModel;
    static /* synthetic */ Class class$com$arsdigita$bebop$event$ParameterListener;

    public abstract boolean isCompound();

    protected abstract String getType();

    protected Widget(String name) {
        this(new StringParameter(name));
    }

    protected Widget(ParameterModel model) {
        Assert.exists(model, class$com$arsdigita$bebop$parameters$ParameterModel == null ? (class$com$arsdigita$bebop$parameters$ParameterModel = Widget.class$("com.arsdigita.bebop.parameters.ParameterModel")) : class$com$arsdigita$bebop$parameters$ParameterModel);
        this.m_parameterModel = model;
    }

    protected ParameterListener createParameterListener() {
        return new ParameterListener(){

            public void validate(ParameterEvent evt) throws FormProcessException {
                Widget.this.fireValidation(new ParameterEvent(Widget.this, evt.getParameterData()));
            }
        };
    }

    public void setValidateInvisible(boolean value) {
        Assert.assertNotLocked(this);
        this.m_validateInvisible = value;
    }

    public boolean validateInvisible() {
        return this.m_validateInvisible;
    }

    protected void fireValidation(ParameterEvent evt) throws FormProcessException {
        Assert.assertLocked(this);
        PageState ps = evt.getPageState();
        if (!this.validateInvisible() && !ps.isVisibleOnPage(this) || this.m_guard != null && this.m_guard.shouldValidate(ps)) {
            return;
        }
        Iterator it = this.m_listeners.getListenerIterator(class$com$arsdigita$bebop$event$ParameterListener == null ? (class$com$arsdigita$bebop$event$ParameterListener = Widget.class$("com.arsdigita.bebop.event.ParameterListener")) : class$com$arsdigita$bebop$event$ParameterListener);
        while (it.hasNext()) {
            ((ParameterListener)it.next()).validate(evt);
        }
    }

    public void addValidationListener(ParameterListener listener) {
        Assert.assertNotNull(listener, "ParameterListener");
        Assert.assertNotLocked(this);
        if (this.m_forwardParameter == null) {
            this.m_forwardParameter = this.createParameterListener();
            this.m_parameterModel.addParameterListener(this.m_forwardParameter);
        }
        this.m_listeners.add(class$com$arsdigita$bebop$event$ParameterListener == null ? (class$com$arsdigita$bebop$event$ParameterListener = Widget.class$("com.arsdigita.bebop.event.ParameterListener")) : class$com$arsdigita$bebop$event$ParameterListener, listener);
    }

    public void removeValidationListener(ParameterListener listener) {
        Assert.assertNotNull(listener, "ParameterListener");
        Assert.assertNotLocked(this);
        this.m_listeners.remove(class$com$arsdigita$bebop$event$ParameterListener == null ? (class$com$arsdigita$bebop$event$ParameterListener = Widget.class$("com.arsdigita.bebop.event.ParameterListener")) : class$com$arsdigita$bebop$event$ParameterListener, listener);
    }

    public void addPrintListener(PrintListener listener) throws TooManyListenersException, IllegalArgumentException {
        if (listener == null) {
            throw new IllegalArgumentException("Argument listener can not be null");
        }
        if (this.m_printListener != null) {
            throw new TooManyListenersException();
        }
        this.m_printListener = listener;
    }

    public void setPrintListener(PrintListener listener) throws IllegalArgumentException {
        if (listener == null) {
            throw new IllegalArgumentException("Argument listener can not be null");
        }
        this.m_printListener = listener;
    }

    public void removePrintListener(PrintListener listener) throws IllegalArgumentException {
        if (listener == null) {
            throw new IllegalArgumentException("listener can not be null");
        }
        if (listener != this.m_printListener) {
            throw new IllegalArgumentException("listener is not registered with this widget");
        }
        this.m_printListener = null;
    }

    public void register(Form form, FormModel model) {
        model.addFormParam(this.getParameterModel());
        this.setForm(form);
    }

    public void setForm(Form form) {
        if (this.m_form != null && form != null) {
            throw new IllegalStateException("Form already set");
        }
        this.m_form = form;
    }

    public Form getForm() throws RuntimeException {
        if (this.m_form == null) {
            throw new RuntimeException("Widget " + this + " (" + this.getName() + ") " + "isn't associated with any Form");
        }
        return this.m_form;
    }

    public void setOnFocus(String javascriptCode) {
        this.setAttribute(ON_FOCUS, javascriptCode);
    }

    public void setOnBlur(String javascriptCode) {
        this.setAttribute(ON_BLUR, javascriptCode);
    }

    public void setOnSelect(String javascriptCode) {
        this.setAttribute(ON_SELECT, javascriptCode);
    }

    public void setOnChange(String javascriptCode) {
        this.setAttribute(ON_CHANGE, javascriptCode);
    }

    public void setOnKeyUp(String javascriptCode) {
        this.setAttribute(ON_KEY_UP, javascriptCode);
    }

    public void setDefaultValue(Object value) {
        this.m_parameterModel.setDefaultValue(value);
    }

    public void setReadOnly() {
        Assert.assertNotLocked(this);
        this.setAttribute("readonly", "readonly");
    }

    public void setDisabled() {
        Assert.assertNotLocked(this);
        this.setAttribute("disabled", "disabled");
    }

    public void setHint(String hint) {
        Assert.assertNotLocked(this);
        this.setAttribute("title", hint);
    }

    public String getDefaultValue() {
        Object o = this.m_parameterModel.getDefaultValue();
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    public String getName() {
        return this.m_parameterModel.getName();
    }

    public final boolean isPassIn() {
        return this.getParameterModel().isPassIn();
    }

    public final void setPassIn(boolean v) {
        Assert.assertNotLocked(this);
        this.getParameterModel().setPassIn(v);
    }

    public final void setParameterModel(ParameterModel parameterModel) {
        Assert.assertNotLocked(this);
        this.m_parameterModel = parameterModel;
    }

    public final ParameterModel getParameterModel() {
        return this.m_parameterModel;
    }

    public void generateXML(PageState state, Element parent) {
        if (this.isVisible(state)) {
            Widget w = this.firePrintEvent(state);
            w.generateWidget(state, parent);
            w.generateErrors(state, parent);
        }
    }

    protected Widget firePrintEvent(PageState state) {
        Widget w = this;
        if (this.m_printListener != null) {
            try {
                w = (Widget)this.clone();
                w.setForm(this.m_form);
                this.m_printListener.prepare(new PrintEvent(this, state, w));
            }
            catch (CloneNotSupportedException e) {
                w = this;
            }
        }
        return w;
    }

    protected String getElementTag() {
        return "bebop:formWidget";
    }

    protected void generateWidget(PageState state, Element parent) {
        Element widget = parent.newChildElement(this.getElementTag(), "http://www.arsdigita.com/bebop/1.0");
        widget.addAttribute("type", this.getType());
        widget.addAttribute("name", this.getName());
        this.exportAttributes(widget);
        String value = null;
        ParameterData p = this.getParameterData(state);
        if (p != null) {
            value = p.marshal();
        }
        if (value == null) {
            value = "";
        }
        widget.addAttribute("value", value);
    }

    protected void generateErrors(PageState state, Element parent) {
        Iterator i = this.getErrors(state);
        while (i.hasNext()) {
            Element errors = parent.newChildElement("bebop:formErrors", "http://www.arsdigita.com/bebop/1.0");
            errors.addAttribute("message", (String)((GlobalizedMessage)i.next()).localize(state.getRequest()));
            errors.addAttribute("id", this.getName());
        }
    }

    public Object getValue(PageState ps) {
        Assert.assertNotNull(ps, "PageState");
        ParameterData p = this.getParameterData(ps);
        return p == null ? this.getDefaultValue() : p.getValue();
    }

    public void setValue(PageState ps, Object value) throws IllegalStateException {
        Assert.assertNotNull(ps, "PageState");
        ParameterData p = this.getParameterData(ps);
        if (p == null) {
            throw new IllegalStateException("Cannot set value for widget '" + this.getName() + "': corresponding form '" + this.getForm().getName() + "' has not been processed yet.");
        }
        p.setValue(value);
    }

    protected Iterator getErrors(PageState ps) {
        Assert.assertNotNull(ps, "PageState");
        FormData f = this.getForm().getFormData(ps);
        if (f != null) {
            return f.getErrors(this.getName());
        }
        return Collections.EMPTY_LIST.iterator();
    }

    protected ParameterData getParameterData(PageState ps) {
        Assert.assertNotNull(ps, "PageState");
        FormData fd = this.getForm().getFormData(ps);
        if (fd != null) {
            return fd.getParameter(this.getName());
        }
        return null;
    }

    public void respond(PageState state) throws ServletException {
        this.getForm().respond(state);
    }

    public Object clone() throws CloneNotSupportedException {
        Widget cloned = (Widget)super.clone();
        cloned.setForm(null);
        return cloned;
    }

    public void setValidationGuard(ValidationGuard guard) {
        Assert.assertNotLocked(this);
        this.m_guard = guard;
    }

    public void addError(GlobalizedMessage mesg) {
        PageState state = PageState.getPageState();
        String error = (String)mesg.localize(Kernel.getContext().getLocale());
        this.getParameterData(state).addError(error);
    }

    public void addError(String error) {
        this.getParameterData(PageState.getPageState()).addError(error);
    }

    public String toString() {
        return super.toString() + " [" + this.getName() + "]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface ValidationGuard {
        public boolean shouldValidate(PageState var1);
    }
}

