/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop.form;

import com.arsdigita.bebop.event.ParameterEvent;
import com.arsdigita.bebop.form.Widget;
import com.arsdigita.bebop.parameters.GlobalizedParameterListener;
import com.arsdigita.bebop.parameters.ParameterData;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.dispatcher.MultipartHttpServletRequest;
import com.arsdigita.globalization.GlobalizedMessage;
import javax.servlet.http.HttpServletRequest;

public class FileUpload
extends Widget {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/form/FileUpload.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public FileUpload(String name) {
        this(name, true);
    }

    public FileUpload(String name, boolean validateInputFile) {
        super(name);
        this.addValidationListener(new FileExistsValidationListener());
    }

    public FileUpload(ParameterModel model) {
        this(model, true);
    }

    public FileUpload(ParameterModel model, boolean validateInputFile) {
        super(model);
        this.addValidationListener(new FileExistsValidationListener());
    }

    public String getType() {
        return "file";
    }

    public boolean isCompound() {
        return false;
    }

    private class FileExistsValidationListener
    extends GlobalizedParameterListener {
        public FileExistsValidationListener() {
            this.setError(new GlobalizedMessage("file_empty_or_not_found", this.getBundleBaseName()));
        }

        public void validate(ParameterEvent e) {
            ParameterData data = e.getParameterData();
            HttpServletRequest request = e.getPageState().getRequest();
            String filename = (String)data.getValue();
            if (!(request instanceof MultipartHttpServletRequest) || filename == null || filename.length() == 0) {
                return;
            }
            if (((MultipartHttpServletRequest)request).getFile(data.getModel().getName()).length() == 0L) {
                data.addError(filename + " " + this.getError().localize());
            }
        }
    }
}

