/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop.demo.workflow;

import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.ToggleLink;
import com.arsdigita.bebop.demo.workflow.AddTask;
import com.arsdigita.bebop.demo.workflow.DisplayTask;
import com.arsdigita.bebop.demo.workflow.Process;
import com.arsdigita.bebop.demo.workflow.SampleProcesses;
import com.arsdigita.bebop.demo.workflow.Task;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.ChangeEvent;
import com.arsdigita.bebop.event.ChangeListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.event.TableActionListener;
import com.arsdigita.bebop.table.DefaultTableCellRenderer;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.util.Assert;
import java.util.Iterator;

public class ProcessDisplay
extends BoxPanel
implements ActionListener,
ChangeListener,
TableActionListener {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/demo/workflow/ProcessDisplay.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private final SingleSelectionModel m_processes;
    private Label m_title;
    private Table m_taskTable;
    private AddTask m_addTaskForm;
    private DisplayTask m_displayTask;
    private ToggleLink m_addTask;

    public ProcessDisplay(SingleSelectionModel m) {
        super(2, false);
        this.m_processes = m;
        this.m_processes.addChangeListener(this);
        this.m_title = this.makeTitle();
        this.add(this.m_title);
        this.m_taskTable = this.makeTaskTable();
        this.add(this.m_taskTable);
        this.m_taskTable.addTableActionListener(this);
        this.m_taskTable.getRowSelectionModel().addChangeListener(this);
        this.m_addTask = new ToggleLink("add task");
        this.add(this.m_addTask);
        this.m_addTask.addActionListener(this);
        this.m_addTaskForm = new AddTask(this.m_processes);
        this.m_addTaskForm.addSubmissionListener(new FormSubmissionListener(){

            public void submitted(FormSectionEvent e) {
                PageState s = e.getPageState();
                if (ProcessDisplay.this.m_addTaskForm.isCancelled(s)) {
                    ProcessDisplay.this.m_addTask.setSelected(s, false);
                    ProcessDisplay.this.m_addTaskForm.setVisible(s, false);
                }
            }
        });
        this.add(this.m_addTaskForm);
        this.m_displayTask = new DisplayTask(this.m_taskTable.getRowSelectionModel());
        this.add(this.m_displayTask);
    }

    public void actionPerformed(ActionEvent e) {
        PageState s = e.getPageState();
        this.addTaskMode(s);
    }

    public void cellSelected(TableActionEvent e) {
        PageState s = e.getPageState();
        if (e.getSource() == this.m_taskTable) {
            this.viewTaskMode(s);
        }
    }

    public void headSelected(TableActionEvent e) {
    }

    public void stateChanged(ChangeEvent e) {
        PageState s = e.getPageState();
        if (e.getSource() == this.m_processes) {
            this.m_addTask.setSelected(s, false);
            this.m_addTaskForm.setVisible(s, false);
            this.m_taskTable.getRowSelectionModel().clearSelection(s);
            this.m_displayTask.setVisible(s, false);
        } else if (e.getSource() == this.m_taskTable.getRowSelectionModel()) {
            this.viewTaskMode(s);
        }
    }

    public void addTaskMode(PageState s) {
        this.m_taskTable.getRowSelectionModel().clearSelection(s);
        this.m_displayTask.setVisible(s, false);
        if (this.m_addTask.isSelected(s)) {
            this.m_addTaskForm.setVisible(s, true);
        }
    }

    public void viewTaskMode(PageState s) {
        if (this.m_taskTable.getRowSelectionModel().isSelected(s)) {
            this.m_addTask.setSelected(s, false);
            this.m_addTaskForm.setVisible(s, false);
            this.m_displayTask.setVisible(s, true);
        } else {
            this.m_displayTask.setVisible(s, false);
        }
    }

    private Table makeTaskTable() {
        Object[] headers = new String[]{"Task", "Depends", "Assignee"};
        TableModelBuilder b = new TableModelBuilder(){
            private boolean m_locked;

            public TableModel makeModel(Table t, PageState s) {
                Assert.assertTrue(ProcessDisplay.this.m_processes.isSelected(s));
                return new TableModel(this, s){
                    private Process p;
                    private int i;
                    private final /* synthetic */ PageState val$s;
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$s = val$s;
                        this.p = SampleProcesses.getProcess(ProcessDisplay.access$200(2.access$300(this.this$1)).getSelectedKey(this.val$s));
                        this.i = -1;
                    }

                    public int getColumnCount() {
                        return 3;
                    }

                    public boolean nextRow() {
                        return ++this.i < this.p.taskCount();
                    }

                    public Object getElementAt(int columnIndex) {
                        if (columnIndex == 0) {
                            return this.p.getTask(this.i).getName();
                        }
                        if (columnIndex == 1) {
                            Task temp_t = this.p.getTask(this.i);
                            boolean first = true;
                            StringBuffer temp_b = new StringBuffer(40);
                            Iterator i = temp_t.dependencies();
                            while (i.hasNext()) {
                                Task dep = (Task)i.next();
                                if (!first) {
                                    temp_b.append(", ");
                                }
                                temp_b.append(dep.getName());
                                first = false;
                            }
                            return temp_b.toString();
                        }
                        if (columnIndex == 2) {
                            return this.p.getTask(this.i).getAssignee();
                        }
                        throw new IllegalArgumentException("columnIndex exceeds number of columns available");
                    }

                    public Object getKeyAt(int columnIndex) {
                        return this.p.getTask(this.i).getKey();
                    }
                };
            }

            public void lock() {
                this.m_locked = true;
            }

            public final boolean isLocked() {
                return this.m_locked;
            }

            static /* synthetic */ ProcessDisplay access$300(2 x0) {
                return x0.ProcessDisplay.this;
            }
        };
        Table result = new Table(b, headers);
        result.getColumn(0).setCellRenderer(new DefaultTableCellRenderer(true));
        return result;
    }

    private Label makeTitle() {
        PrintListener l = new PrintListener(){

            public void prepare(PrintEvent e) {
                Label t = (Label)e.getTarget();
                PageState s = e.getPageState();
                Assert.assertTrue(ProcessDisplay.this.m_processes.isSelected(s));
                Process p = SampleProcesses.getProcess(ProcessDisplay.this.m_processes.getSelectedKey(s));
                t.setLabel("<h4>Details for " + p.getName() + " </h4>");
                t.setOutputEscaping(false);
            }
        };
        return new Label(l);
    }
}

