/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop;

import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.GridPanel;
import com.arsdigita.bebop.ModalContainer;
import com.arsdigita.bebop.MultiStepForm;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.Widget;
import com.arsdigita.bebop.util.Traversal;

public class Wizard
extends MultiStepForm {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/Wizard.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private ModalContainer m_steps = new ModalContainer();
    private Submit m_cancel = new Submit("Cancel");
    private Submit m_back = new Submit("<< Back");
    private Submit m_next = new Submit("Next >>");
    private Submit m_finish = new Submit("Finish");
    private Component m_first = null;
    private Component m_last = null;

    public Wizard(String name) {
        this(name, new GridPanel(1));
    }

    public Wizard(String name, Container panel) {
        super(name, panel);
        super.add(this.m_steps);
        BoxPanel buttons = new BoxPanel(1);
        buttons.add(this.m_cancel);
        buttons.add(this.m_next);
        buttons.add(this.m_back);
        buttons.add(this.m_finish);
        super.add(buttons);
        this.forwardSubmission();
    }

    public void register(Page p) {
        super.register(p);
        p.setVisibleDefault(this.m_back, false);
        p.setVisibleDefault(this.m_finish, false);
        Traversal trav = new Traversal(){

            protected void act(Component c) {
                if (c instanceof Widget) {
                    ((Widget)c).setValidationGuard(new Widget.ValidationGuard(this){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public boolean shouldValidate(PageState ps) {
                            return Wizard.access$100(1.access$000(this.this$1)).isSelected(ps);
                        }
                    });
                }
            }

            static /* synthetic */ Wizard access$000(1 x0) {
                return x0.Wizard.this;
            }
        };
        trav.preorder(this);
    }

    public void add(Container step) {
        if (this.m_first == null) {
            this.m_first = step;
        }
        this.m_steps.add(step);
        this.m_last = step;
    }

    public void add(Container step, int constraints) {
        this.add(step);
    }

    public Submit getCancel() {
        return this.m_cancel;
    }

    public Submit getFinish() {
        return this.m_finish;
    }

    public boolean isFirst(PageState ps) {
        return this.m_steps.getVisibleComponent(ps) == this.m_first;
    }

    public boolean isLast(PageState ps) {
        return this.m_steps.getVisibleComponent(ps) == this.m_last;
    }

    public void next(PageState ps) {
        if (this.isFirst(ps)) {
            this.m_back.setVisible(ps, true);
        }
        this.m_steps.next(ps);
        if (this.isLast(ps)) {
            this.m_next.setVisible(ps, false);
            this.m_finish.setVisible(ps, true);
        }
    }

    public void previous(PageState ps) {
        if (this.isLast(ps)) {
            this.m_next.setVisible(ps, true);
            this.m_finish.setVisible(ps, false);
        }
        this.m_steps.previous(ps);
        if (this.isFirst(ps)) {
            this.m_back.setVisible(ps, false);
        }
    }

    protected void fireSubmitted(FormSectionEvent evt) throws FormProcessException {
        super.fireSubmitted(evt);
        PageState ps = evt.getPageState();
        if (this.m_cancel.isSelected(ps)) {
            this.fireCancel(evt);
            ps.reset(this);
            throw new FormProcessException("cancel hit");
        }
    }

    protected void fireProcess(FormSectionEvent evt) throws FormProcessException {
        PageState ps = evt.getPageState();
        if (this.m_next.isSelected(ps)) {
            this.next(ps);
        } else if (this.m_back.isSelected(ps)) {
            this.previous(ps);
        } else if (this.m_cancel.isSelected(ps)) {
            this.fireCancel(evt);
            ps.reset(this);
        } else if (this.m_finish.isSelected(evt.getPageState())) {
            super.fireProcess(evt);
            ps.reset(this);
        }
    }

    static /* synthetic */ Submit access$100(Wizard x0) {
        return x0.m_back;
    }
}

