/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.parameters.IntegerParameter;
import com.arsdigita.util.Assert;
import com.arsdigita.xml.Element;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import org.apache.log4j.Logger;

public class TabbedPane
extends SimpleContainer {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/TabbedPane.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final String CURRENT_PANE = "pane";
    private static final String SELECT_EVENT = "select";
    private Pane m_defaultPane;
    private IntegerParameter m_currentPaneParam = new IntegerParameter("pane");
    private List m_actionListeners;
    private static final Logger s_log = Logger.getLogger((String)(class$com$arsdigita$bebop$TabbedPane == null ? (class$com$arsdigita$bebop$TabbedPane = TabbedPane.class$("com.arsdigita.bebop.TabbedPane")) : class$com$arsdigita$bebop$TabbedPane).getName());
    static /* synthetic */ Class class$com$arsdigita$bebop$TabbedPane;

    public void register(Page p) {
        Assert.assertNotLocked(this);
        p.addComponentStateParam(this, this.m_currentPaneParam);
        Iterator i = this.children();
        if (!i.hasNext()) {
            s_log.warn((Object)"TabbedPane registered with no panes");
        } else if (this.m_defaultPane == null) {
            this.setDefaultPaneIndex(0);
        }
        while (i.hasNext()) {
            Pane pane = (Pane)i.next();
            p.setVisibleDefault(pane.getComponent(), pane == this.m_defaultPane);
        }
    }

    public void add(Component pc) {
        this.addTab(String.valueOf(this.size()), pc);
    }

    public void add(Component pc, int constraints) {
        this.add(pc);
    }

    public void addTab(Component label, Component c) {
        Assert.assertNotLocked(this);
        super.add(new Pane(label, c));
    }

    public void addTab(String label, Component c) {
        this.addTab(new Label(label), c);
    }

    public void addActionListener(ActionListener l) {
        Assert.assertNotLocked(this);
        if (this.m_actionListeners == null) {
            this.m_actionListeners = new ArrayList();
        }
        this.m_actionListeners.add(l);
    }

    public void removeActionListener(ActionListener l) {
        Assert.assertNotLocked(this);
        if (this.m_actionListeners == null) {
            return;
        }
        this.m_actionListeners.remove(l);
    }

    protected void fireActionEvent(PageState state) {
        ActionEvent e = null;
        if (this.m_actionListeners == null) {
            return;
        }
        Iterator i = this.m_actionListeners.iterator();
        while (i.hasNext()) {
            if (e == null) {
                e = new ActionEvent(this, state);
            }
            ((ActionListener)i.next()).actionPerformed(e);
        }
    }

    protected void setDefaultPaneIndex(int i) {
        this.m_currentPaneParam.setDefaultValue(new Integer(i));
        this.m_defaultPane = (Pane)this.get(i);
    }

    public void setDefaultPane(Component pane) throws IllegalArgumentException {
        Assert.assertNotLocked(this);
        this.setDefaultPaneIndex(this.findPaneSafe(pane));
    }

    public void setTabVisible(PageState s, int i, boolean v) {
        this.get(i).setVisible(s, v);
    }

    public void setTabVisible(PageState s, Component c, boolean v) {
        int i = this.findPaneSafe(c);
        this.setTabVisible(s, i, v);
    }

    public boolean isTabVisible(PageState s, int i) {
        return this.get(i).isVisible(s);
    }

    public boolean isTabVisible(PageState s, Component c) {
        int i = this.findPaneSafe(c);
        return this.isTabVisible(s, i);
    }

    protected int findPane(Component c) {
        int index = 0;
        Iterator i = this.children();
        while (i.hasNext()) {
            Pane p = (Pane)i.next();
            if (p.getComponent() == c) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private int findPaneSafe(Component c) {
        int i = this.findPane(c);
        if (i == -1) {
            throw new IllegalArgumentException("Pane not part of this tabbed dialog");
        }
        return i;
    }

    public Component getDefaultPane() {
        return this.m_defaultPane.getComponent();
    }

    public Component getPane(Component label) {
        Iterator i = this.children();
        while (i.hasNext()) {
            Pane p = (Pane)i.next();
            if (!p.getLabel().equals(label)) continue;
            return p.getComponent();
        }
        return null;
    }

    public Component getPane(String label) {
        Iterator i = this.children();
        while (i.hasNext()) {
            Pane p = (Pane)i.next();
            Component pLabel = p.getLabel();
            if (!(pLabel instanceof Label) || !((Label)pLabel).getLabel().equals(label)) continue;
            return p.getComponent();
        }
        return null;
    }

    public Component getCurrentPane(PageState data) {
        return this.getCurrent(data).getComponent();
    }

    private Pane getCurrent(PageState data) {
        Integer i = (Integer)data.getValue(this.m_currentPaneParam);
        if (i == null) {
            if (this.m_defaultPane != null) {
                return this.m_defaultPane;
            }
            return (Pane)this.get(0);
        }
        return (Pane)this.get(i);
    }

    public void setSelectedIndex(PageState state, int index) {
        if (index != this.getSelectedIndex(state)) {
            this.getCurrentPane(state).setVisible(state, false);
            state.setValue(this.m_currentPaneParam, new Integer(index));
            this.getCurrentPane(state).setVisible(state, true);
        }
    }

    public int getSelectedIndex(PageState state) {
        Integer current = (Integer)state.getValue(this.m_currentPaneParam);
        if (current == null) {
            return -1;
        }
        return current;
    }

    protected void generateTabs(PageState data, Element parent) {
        Element strip = parent.newChildElement("bebop:tabStrip", "http://www.arsdigita.com/bebop/1.0");
        this.exportAttributes(strip);
        Pane current = this.getCurrent(data);
        Iterator tabs = this.children();
        int i = 0;
        while (tabs.hasNext()) {
            Pane pane = (Pane)tabs.next();
            if (pane.isVisible(data)) {
                data.setControlEvent(this, SELECT_EVENT, String.valueOf(i));
                Element tab = strip.newChildElement("bebop:tab", "http://www.arsdigita.com/bebop/1.0");
                if (pane == current) {
                    tab.addAttribute("current", "t");
                } else {
                    try {
                        tab.addAttribute("href", data.stateAsURL());
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
                pane.getLabel().generateXML(data, tab);
            }
            ++i;
        }
        data.clearControlEvent();
    }

    public void generateXML(PageState state, Element parent) {
        if (this.isVisible(state) && !this.isEmpty()) {
            Element tabbed = parent.newChildElement("bebop:tabbedPane", "http://www.arsdigita.com/bebop/1.0");
            this.generateTabs(state, tabbed);
            this.exportAttributes(tabbed);
            Element pane = tabbed.newChildElement("bebop:currentPane", "http://www.arsdigita.com/bebop/1.0");
            this.exportAttributes(pane);
            this.getCurrentPane(state).generateXML(state, pane);
        }
    }

    public void respond(PageState state) throws ServletException {
        String event = state.getControlEventName();
        if (!SELECT_EVENT.equals(event)) {
            throw new ServletException("Received unknown control event " + event);
        }
        String value = state.getControlEventValue();
        this.setSelectedIndex(state, Integer.parseInt(value));
        this.fireActionEvent(state);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Pane
    extends SimpleContainer {
        private Component m_label;
        private Component m_component;

        public Pane(Component label, Component c) {
            this.m_label = label;
            super.add(label);
            this.m_component = c;
            super.add(c);
        }

        public final Component getLabel() {
            return this.m_label;
        }

        public final Component getComponent() {
            return this.m_component;
        }
    }
}

