/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop;

import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ComponentSelectionModel;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.MapComponentSelectionModel;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.ParameterSingleSelectionModel;
import com.arsdigita.bebop.SplitWizard;
import com.arsdigita.bebop.event.ChangeEvent;
import com.arsdigita.bebop.event.ChangeListener;
import com.arsdigita.bebop.list.DefaultListCellRenderer;
import com.arsdigita.bebop.parameters.IntegerParameter;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.bebop.util.SequentialMap;

public class MapWizard
extends SplitWizard {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/MapWizard.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    public static final String CURRENT_STEP = "cs";
    public static final String PROGRESS = "p";
    private SequentialMap m_labels;
    private SequentialMap m_panels;
    private Label m_listLabel;
    private List m_list;
    private StringParameter m_stepParam = new StringParameter("cs");
    private IntegerParameter m_progressParam = new IntegerParameter("p");

    public MapWizard(String header, String listLabel) {
        super((Component)new Label(header), (ComponentSelectionModel)null, (Component)null);
        this.setDefaultProgress(0);
        this.m_labels = new SequentialMap();
        this.m_panels = new SequentialMap();
        ParameterSingleSelectionModel s = new ParameterSingleSelectionModel(this.m_stepParam);
        s.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                int prog;
                PageState state = e.getPageState();
                String key = MapWizard.this.getCurrentStepKey(state);
                if (key == null) {
                    return;
                }
                if (!MapWizard.this.m_panels.containsKey(key)) {
                    throw new IllegalArgumentException("Key " + key + " is not in the wizard");
                }
                int i = MapWizard.this.m_panels.findKey(key);
                if (i > (prog = MapWizard.this.getProgress(state))) {
                    throw new IllegalArgumentException("Key " + key + " identifies the component at index " + i + ", but the highest enabled step is " + prog);
                }
            }
        });
        MapComponentSelectionModel sel = new MapComponentSelectionModel(s, this.m_panels);
        this.setSelectionModel(sel);
        this.m_list = new List(sel);
        this.m_list.setCellRenderer(new ProgressListCellRenderer());
        this.m_list.setListData(this.m_labels);
        BoxPanel box = new BoxPanel(2);
        box.setBorder(0);
        if (listLabel != null) {
            this.m_listLabel = new Label(listLabel);
            this.m_listLabel.setFontWeight("b");
            box.add(this.m_listLabel);
        }
        box.add(this.m_list);
        this.setSelector(box);
        super.setClassAttr("mapWizard");
    }

    public MapWizard(String header) {
        this(header, null);
    }

    public void register(Page p) {
        super.register(p);
        p.addComponent(this);
        p.addComponentStateParam(this, this.m_progressParam);
    }

    public void add(String key, String label, Component c) {
        if (this.m_labels.containsKey(key)) {
            throw new IllegalArgumentException("Wizard already contains the key '" + key + "'");
        }
        if (this.getDefaultStepKey() == null) {
            this.setDefaultStepKey(key);
        }
        this.m_labels.put(key, label);
        this.m_panels.put(key, c);
        super.add(c);
    }

    public void add(String key, String label, String caption, Component c) {
        this.add(key, label, new SplitWizard.HeaderPanel(caption, c));
    }

    public final Label getListLabel() {
        return this.m_listLabel;
    }

    public int getStepCount() {
        return this.m_panels.size();
    }

    public final List getList() {
        return this.m_list;
    }

    public void add(Component c) {
        throw new UnsupportedOperationException("Use add(String key, String label, Component c)");
    }

    public void add(Component c, int constraints) {
        throw new UnsupportedOperationException("Use add(String key, String label, Component c)");
    }

    public int getProgress(PageState state) {
        return (Integer)state.getValue(this.m_progressParam);
    }

    public void setProgress(PageState state, int p) {
        if (p < -1 || p >= this.getStepCount()) {
            throw new IllegalArgumentException("Expecting an integer between -1 and " + (this.getStepCount() - 1) + ", but got " + p);
        }
        state.setValue(this.m_progressParam, new Integer(p));
    }

    public void setDefaultProgress(int index) {
        this.m_progressParam.setDefaultValue(new Integer(index));
    }

    public int getDefaultProgress() {
        return (Integer)this.m_progressParam.getDefaultValue();
    }

    public void setDefaultStepKey(String key) {
        this.m_stepParam.setDefaultValue(key);
    }

    public String getDefaultStepKey() {
        return (String)this.m_stepParam.getDefaultValue();
    }

    public String getCurrentStepKey(PageState state) {
        return (String)this.getSelectionModel().getSelectedKey(state);
    }

    public void setCurrentStepKey(PageState state, String key) {
        this.getSelectionModel().setSelectedKey(state, key);
    }

    public int getCurrentStep(PageState state) {
        String key = (String)this.getSelectionModel().getSelectedKey(state);
        if (key == null) {
            return 0;
        }
        return this.m_panels.findKey(key);
    }

    public void setCurrentStep(PageState state, int step) {
        this.setCurrentStepKey(state, this.getStepKey(step));
    }

    public void stepForward(PageState state) {
        this.stepForward(state, false);
    }

    public void stepForward(PageState state, boolean force) {
        int p;
        int s = this.getCurrentStep(state);
        if (s < (p = this.getProgress(state))) {
            this.setCurrentStep(state, s + 1);
        } else if (s == p && force) {
            this.setProgress(state, p + 1);
            this.setCurrentStep(state, s + 1);
        }
    }

    public void stepBack(PageState state) {
        int i = this.getCurrentStep(state);
        if (i > 0) {
            this.setCurrentStep(state, i - 1);
        }
    }

    public String getStepKey(int i) {
        return (String)this.m_panels.getKey(i);
    }

    protected final SequentialMap getLabelsMap() {
        return this.m_labels;
    }

    protected final SequentialMap getPanelsMap() {
        return this.m_panels;
    }

    private class ProgressListCellRenderer
    extends DefaultListCellRenderer {
        private static final String DIS_OPEN = "<font color=\"#bbbbbb\"><b>";
        private static final String DIS_CLOSE = "</b></font>";

        private ProgressListCellRenderer() {
        }

        public Component getComponent(List list, PageState state, Object value, String key, int index, boolean isSelected) {
            Component c = null;
            int p = MapWizard.this.getProgress(state);
            if (p == -1 || p < index) {
                StringBuffer s = new StringBuffer(DIS_OPEN);
                s.append(MapWizard.this.m_labels.get(key));
                s.append(DIS_CLOSE);
                c = new Label(s.toString(), false);
            } else {
                c = super.getComponent(list, state, value, key, index, isSelected);
            }
            return c;
        }
    }
}

