/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.ParameterSingleSelectionModel;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.ChangeEvent;
import com.arsdigita.bebop.event.ChangeListener;
import com.arsdigita.bebop.event.EventListenerList;
import com.arsdigita.bebop.list.DefaultListCellRenderer;
import com.arsdigita.bebop.list.ListCellRenderer;
import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.bebop.list.ListModelBuilder;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.bebop.util.BebopConstants;
import com.arsdigita.util.Assert;
import com.arsdigita.xml.Element;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletException;

public class List
extends SimpleComponent
implements BebopConstants {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/List.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    public static final String SELECTED = "sel";
    public static final String SELECT_EVENT = "s";
    private ListModelBuilder m_modelBuilder;
    private RequestLocal m_model;
    private ListCellRenderer m_renderer = new DefaultListCellRenderer();
    private EventListenerList m_listeners = new EventListenerList();
    private SingleSelectionModel m_selection;
    private ChangeListener m_changeListener;
    private Component m_emptyView;
    private boolean m_stateParamsAreRegistered;
    public static final int VERTICAL = 0;
    public static final int HORIZONTAL = 1;
    private int m_layout = 0;
    public static final ListModel EMPTY_MODEL = new ListModel(){

        public boolean next() {
            return false;
        }

        public String getKey() {
            throw new IllegalStateException("ListModel is empty");
        }

        public Object getElement() {
            throw new IllegalStateException("ListModel is empty");
        }
    };
    static /* synthetic */ Class class$com$arsdigita$bebop$event$ChangeListener;
    static /* synthetic */ Class class$com$arsdigita$bebop$event$ActionListener;

    public List(ListModelBuilder b) {
        this();
        this.m_modelBuilder = b;
        this.m_emptyView = null;
    }

    public List() {
        this((SingleSelectionModel)null);
        this.m_selection = new ParameterSingleSelectionModel(new StringParameter(SELECTED));
    }

    public List(SingleSelectionModel selection) {
        this.m_selection = selection;
        this.setListData(new Object[0]);
        this.initListModel();
        this.m_emptyView = null;
        this.m_stateParamsAreRegistered = true;
    }

    public List(Object[] values) {
        this();
        this.setListData(values);
    }

    public List(Map map) {
        this();
        this.setListData(map);
    }

    public void register(Page p) {
        Assert.assertNotLocked(this);
        if (this.m_selection.getStateParameter() != null) {
            p.addComponentStateParam(this, this.m_selection.getStateParameter());
        }
    }

    public void respond(PageState state) throws ServletException {
        String event = state.getControlEventName();
        if (!SELECT_EVENT.equals(event)) {
            throw new ServletException("Unknown event '" + event + "'");
        }
        this.setSelectedKey(state, state.getControlEventValue());
        this.fireActionEvent(state);
    }

    public void generateXML(PageState state, Element parent) {
        if (!this.isVisible(state)) {
            return;
        }
        ListModel m = this.getModel(state);
        if (m.next()) {
            Element list = parent.newChildElement("bebop:list", "http://www.arsdigita.com/bebop/1.0");
            this.exportAttributes(list);
            if (this.m_layout == 0) {
                list.addAttribute("layout", "vertical");
            } else {
                list.addAttribute("layout", "horizontal");
            }
            Object selKey = this.getStateParamsAreRegistered() ? this.getSelectedKey(state) : null;
            int i = 0;
            do {
                Element item = list.newChildElement("bebop:cell", "http://www.arsdigita.com/bebop/1.0");
                String key = m.getKey();
                Assert.assertNotNull(key);
                boolean selected = selKey != null && key.equals(selKey.toString());
                item.addAttribute("key", key);
                if (selected) {
                    item.addAttribute("selected", "selected");
                }
                if (this.getStateParamsAreRegistered()) {
                    state.setControlEvent(this, SELECT_EVENT, key);
                }
                Component c = this.getCellRenderer().getComponent(this, state, m.getElement(), key, i, selected);
                c.generateXML(state, item);
                ++i;
            } while (m.next());
        } else if (this.m_emptyView != null) {
            this.m_emptyView.generateXML(state, parent);
        } else {
            Element list = parent.newChildElement("bebop:list", "http://www.arsdigita.com/bebop/1.0");
            this.exportAttributes(list);
        }
        state.clearControlEvent();
    }

    public int getLayout() {
        return this.m_layout;
    }

    public void setLayout(int layout) {
        Assert.assertNotLocked(this);
        Assert.assertTrue(layout == 0 || layout == 1, "Invalid layout code passed to setLayout");
        this.m_layout = layout;
    }

    public void setStateParamsAreRegistered(boolean val) {
        this.m_stateParamsAreRegistered = val;
    }

    public boolean getStateParamsAreRegistered() {
        return this.m_stateParamsAreRegistered;
    }

    public final ListCellRenderer getCellRenderer() {
        return this.m_renderer;
    }

    public final void setCellRenderer(ListCellRenderer r) {
        Assert.assertNotLocked(this);
        this.m_renderer = r;
    }

    public final ListModelBuilder getModelBuilder() {
        return this.m_modelBuilder;
    }

    public final void setModelBuilder(ListModelBuilder b) {
        Assert.assertNotLocked(this);
        this.m_modelBuilder = b;
    }

    public final void setEmptyView(Component c) {
        Assert.assertNotLocked(this);
        this.m_emptyView = c;
    }

    public final Component getEmptyView() {
        return this.m_emptyView;
    }

    private void initListModel() {
        this.m_model = new RequestLocal(){

            protected Object initialValue(PageState s) {
                return List.this.getModelBuilder().makeModel(List.this, s);
            }
        };
    }

    public ListModel getModel(PageState state) {
        return (ListModel)this.m_model.get(state);
    }

    public void setListData(Object[] values) {
        Assert.assertNotLocked(this);
        this.m_modelBuilder = new ArrayListModelBuilder(values);
    }

    public void setListData(Map map) {
        Assert.assertNotLocked(this);
        this.m_modelBuilder = new MapListModelBuilder(map);
    }

    public final SingleSelectionModel getSelectionModel() {
        return this.m_selection;
    }

    public final void setSelectionModel(SingleSelectionModel m) {
        Assert.assertNotLocked(this);
        if (this.m_changeListener != null) {
            this.m_selection.removeChangeListener(this.m_changeListener);
            m.addChangeListener(this.m_changeListener);
        }
        this.m_selection = m;
    }

    public Object getSelectedKey(PageState state) {
        return this.m_selection.getSelectedKey(state);
    }

    public void setSelectedKey(PageState state, String key) {
        this.m_selection.setSelectedKey(state, key);
    }

    public boolean isSelected(PageState state) {
        return this.m_selection.isSelected(state);
    }

    public void clearSelection(PageState state) {
        this.m_selection.clearSelection(state);
    }

    protected ChangeListener createChangeListener() {
        return new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                List.this.fireStateChanged(e.getPageState());
            }
        };
    }

    public void addChangeListener(ChangeListener l) {
        Assert.assertNotLocked(this);
        if (this.m_changeListener == null) {
            this.m_changeListener = this.createChangeListener();
            this.m_selection.addChangeListener(this.m_changeListener);
        }
        this.m_listeners.add(class$com$arsdigita$bebop$event$ChangeListener == null ? (class$com$arsdigita$bebop$event$ChangeListener = List.class$("com.arsdigita.bebop.event.ChangeListener")) : class$com$arsdigita$bebop$event$ChangeListener, l);
    }

    public void removeChangeListener(ChangeListener l) {
        Assert.assertNotLocked(this);
        this.m_listeners.remove(class$com$arsdigita$bebop$event$ChangeListener == null ? (class$com$arsdigita$bebop$event$ChangeListener = List.class$("com.arsdigita.bebop.event.ChangeListener")) : class$com$arsdigita$bebop$event$ChangeListener, l);
    }

    protected void fireStateChanged(PageState state) {
        Iterator i = this.m_listeners.getListenerIterator(class$com$arsdigita$bebop$event$ChangeListener == null ? (class$com$arsdigita$bebop$event$ChangeListener = List.class$("com.arsdigita.bebop.event.ChangeListener")) : class$com$arsdigita$bebop$event$ChangeListener);
        ChangeEvent e = null;
        while (i.hasNext()) {
            if (e == null) {
                e = new ChangeEvent(this, state);
            }
            ((ChangeListener)i.next()).stateChanged(e);
        }
    }

    public void addActionListener(ActionListener l) {
        Assert.assertNotLocked(this);
        this.m_listeners.add(class$com$arsdigita$bebop$event$ActionListener == null ? (class$com$arsdigita$bebop$event$ActionListener = List.class$("com.arsdigita.bebop.event.ActionListener")) : class$com$arsdigita$bebop$event$ActionListener, l);
    }

    public void removeActionListener(ActionListener l) {
        Assert.assertNotLocked(this);
        this.m_listeners.remove(class$com$arsdigita$bebop$event$ActionListener == null ? (class$com$arsdigita$bebop$event$ActionListener = List.class$("com.arsdigita.bebop.event.ActionListener")) : class$com$arsdigita$bebop$event$ActionListener, l);
    }

    protected void fireActionEvent(PageState state) {
        Iterator i = this.m_listeners.getListenerIterator(class$com$arsdigita$bebop$event$ActionListener == null ? (class$com$arsdigita$bebop$event$ActionListener = List.class$("com.arsdigita.bebop.event.ActionListener")) : class$com$arsdigita$bebop$event$ActionListener);
        ActionEvent e = null;
        while (i.hasNext()) {
            if (e == null) {
                e = new ActionEvent(this, state);
            }
            ((ActionListener)i.next()).actionPerformed(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ArrayListModelBuilder
    implements ListModelBuilder {
        private Object[] m_values;
        private boolean m_locked;

        public ArrayListModelBuilder() {
            this(new Object[0]);
        }

        public ArrayListModelBuilder(Object[] values) {
            this.m_values = values;
        }

        public ListModel makeModel(List l, PageState state) {
            return new ListModel(this){
                private int i;
                private final /* synthetic */ ArrayListModelBuilder this$0;
                {
                    this.this$0 = this$0;
                    this.i = -1;
                }

                public boolean next() {
                    ++this.i;
                    return this.i < ArrayListModelBuilder.access$100(this.this$0).length;
                }

                public Object getElement() {
                    this.checkState();
                    return ArrayListModelBuilder.access$100(this.this$0)[this.i];
                }

                public String getKey() {
                    this.checkState();
                    return String.valueOf(this.i);
                }

                private void checkState() {
                    if (this.i < 0) {
                        throw new IllegalStateException("Before first item. Call next() first.");
                    }
                    if (this.i >= ArrayListModelBuilder.access$100(this.this$0).length) {
                        throw new IllegalStateException("After last item. Model exhausted.");
                    }
                }
            };
        }

        public void lock() {
            this.m_locked = true;
        }

        public final boolean isLocked() {
            return this.m_locked;
        }

        static /* synthetic */ Object[] access$100(ArrayListModelBuilder x0) {
            return x0.m_values;
        }
    }

    private static class MapListModelBuilder
    implements ListModelBuilder {
        private Map m_map;
        private boolean m_locked;

        public MapListModelBuilder() {
            this(Collections.EMPTY_MAP);
        }

        public MapListModelBuilder(Map m) {
            this.m_map = m;
        }

        public ListModel makeModel(List l, PageState state) {
            return new ListModel(this){
                private Iterator i;
                private Map.Entry e;
                private final /* synthetic */ MapListModelBuilder this$0;
                {
                    this.this$0 = this$0;
                    this.i = MapListModelBuilder.access$000(this.this$0).entrySet().iterator();
                    this.e = null;
                }

                public boolean next() {
                    if (!this.i.hasNext()) {
                        this.e = null;
                        return false;
                    }
                    this.e = (Map.Entry)this.i.next();
                    return true;
                }

                public Object getElement() {
                    this.checkState();
                    return this.e.getValue();
                }

                public String getKey() {
                    this.checkState();
                    return this.e.getKey().toString();
                }

                private void checkState() {
                    if (this.e == null) {
                        throw new IllegalStateException("No valid current item. Model is either before first item or after last item");
                    }
                }
            };
        }

        public void lock() {
            this.m_locked = true;
        }

        public final boolean isLocked() {
            return this.m_locked;
        }

        static /* synthetic */ Map access$000(MapListModelBuilder x0) {
            return x0.m_map;
        }
    }
}

