/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.bebop.util.Traversal;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ComponentPool {
    public static final String versionId = "$Author: dennis $ - $Date: 2004/04/07 $ $Id: //core-platform/dev/src/com/arsdigita/bebop/ComponentPool.java#11 $";
    private static final Logger s_cat = Logger.getLogger((String)(class$com$arsdigita$bebop$ComponentPool == null ? (class$com$arsdigita$bebop$ComponentPool = ComponentPool.class$("com.arsdigita.bebop.ComponentPool")) : class$com$arsdigita$bebop$ComponentPool).getName());
    private Map m_pools = Collections.synchronizedMap(new HashMap());
    private static int s_retryLimit = 3;
    private static int s_retrySleep = 50;
    private static ComponentPool s_instance = new ComponentPool();
    static /* synthetic */ Class class$com$arsdigita$bebop$ComponentPool;

    public static ComponentPool getInstance() {
        return s_instance;
    }

    public void setPoolSize(Class c, int num) {
        _pool p = (_pool)this.m_pools.get(c.getName());
        if (p == null) {
            p = new _pool();
            this.m_pools.put(c.getName(), p);
        }
        p.setPoolSize(c, num);
    }

    public Component getComponent(Class componentClass) {
        int retries = 0;
        _pool pool = (_pool)this.m_pools.get(componentClass.getName());
        if (pool == null) {
            this.setPoolSize(componentClass, 10);
            pool = (_pool)this.m_pools.get(componentClass.getName());
        }
        do {
            Component c;
            if ((c = pool.getComponent()) == null) {
                ++retries;
                try {
                    Thread.sleep(s_retrySleep);
                }
                catch (InterruptedException e) {}
                continue;
            }
            return c;
        } while (retries <= s_retryLimit);
        s_cat.error((Object)("could not retrieve component of type " + componentClass));
        throw new RuntimeException(componentClass.getName());
    }

    public void returnToPool(Component c) {
        _pool pool = (_pool)this.m_pools.get(c.getClass().getName());
        if (pool != null) {
            pool.returnToPool(c);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class _pool {
        List m_usedComponents = Collections.synchronizedList(new LinkedList());
        List m_availComponents = Collections.synchronizedList(new LinkedList());
        private Class m_class;
        private int m_maxSize = -1;

        public void setPoolSize(Class c, int num) {
            this.m_class = c;
            this.m_maxSize = num;
            while (this.m_availComponents.size() < this.m_maxSize) {
                try {
                    Component p = (Component)this.m_class.newInstance();
                    this.m_availComponents.add(p);
                }
                catch (InstantiationException e) {
                    s_cat.error((Object)"setPoolSize", (Throwable)e);
                    break;
                }
                catch (IllegalAccessException e) {
                    s_cat.error((Object)"setPoolSize", (Throwable)e);
                    break;
                }
            }
        }

        public Component getComponent() {
            Component p = null;
            try {
                p = (Component)this.m_availComponents.remove(0);
                this.m_usedComponents.add(p);
            }
            catch (IndexOutOfBoundsException e) {
                s_cat.error((Object)"getComponent: free list was empty");
            }
            return p;
        }

        public void returnToPool(Component p) {
            if (this.m_usedComponents.remove(p)) {
                Traversal tr = new Traversal(this){
                    private final /* synthetic */ _pool this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void act(Component c) {
                        if (c instanceof SimpleComponent) {
                            ((SimpleComponent)c).unlock();
                        }
                    }
                };
                tr.preorder(p);
                this.m_availComponents.add(p);
            }
        }
    }
}

