/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.trax;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TemplatesHandler;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import org.apache.xalan.xsltc.compiler.SourceLoader;
import org.apache.xalan.xsltc.compiler.XSLTC;
import org.apache.xalan.xsltc.compiler.util.ErrorMsg;
import org.apache.xalan.xsltc.trax.DOM2SAX;
import org.apache.xalan.xsltc.trax.TemplatesHandlerImpl;
import org.apache.xalan.xsltc.trax.TemplatesImpl;
import org.apache.xalan.xsltc.trax.TrAXFilter;
import org.apache.xalan.xsltc.trax.TransformerHandlerImpl;
import org.apache.xalan.xsltc.trax.TransformerImpl;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.XMLFilter;

public class TransformerFactoryImpl
extends SAXTransformerFactory
implements SourceLoader,
ErrorListener {
    private ErrorListener _errorListener = this;
    private URIResolver _uriResolver = null;
    protected static String _defaultTransletName = "GregorSamsa";
    private Transformer _copyTransformer = null;
    private static final String COPY_TRANSLET_CODE = "<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"><xsl:template match=\"/\">  <xsl:copy-of select=\".\"/></xsl:template></xsl:stylesheet>";
    private Hashtable _piParams = null;
    private boolean _debug = false;
    private boolean _disableInlining = false;
    private boolean _oldOutputSystem = false;

    public void setErrorListener(ErrorListener listener) throws IllegalArgumentException {
        if (listener == null) {
            ErrorMsg err = new ErrorMsg(59, "TransformerFactory");
            throw new IllegalArgumentException(err.toString());
        }
        this._errorListener = listener;
    }

    public ErrorListener getErrorListener() {
        return this._errorListener;
    }

    public Object getAttribute(String name) throws IllegalArgumentException {
        if (name.equals("translet-name")) {
            return _defaultTransletName;
        }
        ErrorMsg err = new ErrorMsg(63, name);
        throw new IllegalArgumentException(err.toString());
    }

    public void setAttribute(String name, Object value) throws IllegalArgumentException {
        if (name.equals("translet-name") && value instanceof String) {
            _defaultTransletName = (String)value;
        } else if (name.equals("debug")) {
            this._debug = true;
        } else if (name.equals("disable-inlining") && value instanceof Boolean) {
            this._disableInlining = (Boolean)value;
        } else if (name.equals("old-output") && value instanceof Boolean) {
            this._oldOutputSystem = (Boolean)value;
        } else {
            ErrorMsg err = new ErrorMsg(63, name);
            throw new IllegalArgumentException(err.toString());
        }
    }

    public boolean getFeature(String name) {
        String[] features = new String[]{"http://javax.xml.transform.dom.DOMSource/feature", "http://javax.xml.transform.dom.DOMResult/feature", "http://javax.xml.transform.sax.SAXSource/feature", "http://javax.xml.transform.sax.SAXResult/feature", "http://javax.xml.transform.stream.StreamSource/feature", "http://javax.xml.transform.stream.StreamResult/feature"};
        int i = 0;
        while (i < features.length) {
            if (name.equals(features[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public URIResolver getURIResolver() {
        return this._uriResolver;
    }

    public void setURIResolver(URIResolver resolver) {
        this._uriResolver = resolver;
    }

    public Source getAssociatedStylesheet(Source source, String media, String title, String charset) throws TransformerConfigurationException {
        if (this._piParams == null) {
            this._piParams = new Hashtable();
        }
        this._piParams.put(source, new PIParamWrapper(media, title, charset));
        return source;
    }

    public Transformer newTransformer() throws TransformerConfigurationException {
        if (this._copyTransformer != null) {
            if (this._uriResolver != null) {
                this._copyTransformer.setURIResolver(this._uriResolver);
            }
            return this._copyTransformer;
        }
        XSLTC xsltc = new XSLTC();
        if (this._debug) {
            xsltc.setDebug(true);
        }
        if (this._disableInlining) {
            xsltc.setTemplateInlining(false);
        }
        xsltc.init();
        byte[] bytes = COPY_TRANSLET_CODE.getBytes();
        ByteArrayInputStream bytestream = new ByteArrayInputStream(bytes);
        InputSource input = new InputSource(bytestream);
        input.setSystemId(_defaultTransletName);
        byte[][] bytecodes = xsltc.compile(_defaultTransletName, input);
        if (bytecodes == null) {
            ErrorMsg err = new ErrorMsg(62);
            throw new TransformerConfigurationException(err.toString());
        }
        TemplatesImpl templates = new TemplatesImpl(bytecodes, _defaultTransletName, this._oldOutputSystem);
        this._copyTransformer = templates.newTransformer();
        if (this._uriResolver != null) {
            this._copyTransformer.setURIResolver(this._uriResolver);
        }
        return this._copyTransformer;
    }

    public Transformer newTransformer(Source source) throws TransformerConfigurationException {
        Templates templates = this.newTemplates(source);
        Transformer transformer = templates.newTransformer();
        if (this._uriResolver != null) {
            transformer.setURIResolver(this._uriResolver);
        }
        return transformer;
    }

    private void passWarningsToListener(Vector messages) {
        try {
            if (this._errorListener == null) {
                return;
            }
            if (messages == null) {
                return;
            }
            int count = messages.size();
            int pos = 0;
            while (pos < count) {
                String message = messages.elementAt(pos).toString();
                this._errorListener.warning(new TransformerException(message));
                ++pos;
            }
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
    }

    private void passErrorsToListener(Vector messages) {
        try {
            if (this._errorListener == null) {
                return;
            }
            if (messages == null) {
                return;
            }
            int count = messages.size();
            int pos = 0;
            while (pos < count) {
                String message = messages.elementAt(pos).toString();
                this._errorListener.error(new TransformerException(message));
                ++pos;
            }
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
    }

    private InputSource getInputSource(XSLTC xsltc, Source source) throws TransformerConfigurationException {
        InputSource input = null;
        String systemId = source.getSystemId();
        if (systemId == null) {
            systemId = "";
        }
        try {
            try {
                if (source instanceof SAXSource) {
                    SAXSource sax = (SAXSource)source;
                    input = sax.getInputSource();
                    xsltc.setXMLReader(sax.getXMLReader());
                } else if (source instanceof DOMSource) {
                    DOMSource domsrc = (DOMSource)source;
                    Document dom = (Document)domsrc.getNode();
                    DOM2SAX dom2sax = new DOM2SAX(dom);
                    xsltc.setXMLReader(dom2sax);
                    input = SAXSource.sourceToInputSource(source);
                    if (input == null) {
                        input = new InputSource(domsrc.getSystemId());
                    }
                } else if (source instanceof StreamSource) {
                    StreamSource stream = (StreamSource)source;
                    InputStream istream = stream.getInputStream();
                    Reader reader = stream.getReader();
                    input = istream != null ? new InputSource(istream) : (reader != null ? new InputSource(reader) : new InputSource(systemId));
                } else {
                    ErrorMsg err = new ErrorMsg(60);
                    throw new TransformerConfigurationException(err.toString());
                }
                input.setSystemId(systemId);
            }
            catch (NullPointerException e) {
                ErrorMsg err = new ErrorMsg(61, "TransformerFactory.newTemplates()");
                throw new TransformerConfigurationException(err.toString());
            }
            catch (SecurityException e) {
                ErrorMsg err = new ErrorMsg(10, systemId);
                throw new TransformerConfigurationException(err.toString());
            }
            Object var9_17 = null;
            return input;
        }
        catch (Throwable throwable) {
            Object var9_18 = null;
            return input;
        }
    }

    public Templates newTemplates(Source source) throws TransformerConfigurationException {
        PIParamWrapper p;
        XSLTC xsltc = new XSLTC();
        if (this._debug) {
            xsltc.setDebug(true);
        }
        if (this._disableInlining) {
            xsltc.setTemplateInlining(false);
        }
        xsltc.init();
        if (this._uriResolver != null) {
            xsltc.setSourceLoader(this);
        }
        if (this._piParams != null && this._piParams.get(source) != null && (p = (PIParamWrapper)this._piParams.get(source)) != null) {
            xsltc.setPIParameters(p._media, p._title, p._charset);
        }
        InputSource input = this.getInputSource(xsltc, source);
        byte[][] bytecodes = xsltc.compile(null, input);
        String transletName = xsltc.getClassName();
        if (this._errorListener != null) {
            this.passWarningsToListener(xsltc.getWarnings());
        } else {
            xsltc.printWarnings();
        }
        if (bytecodes == null) {
            if (this._errorListener != null) {
                this.passErrorsToListener(xsltc.getErrors());
            } else {
                xsltc.printErrors();
            }
            ErrorMsg err = new ErrorMsg(62);
            throw new TransformerConfigurationException(err.toString());
        }
        return new TemplatesImpl(bytecodes, transletName, this._oldOutputSystem);
    }

    public TemplatesHandler newTemplatesHandler() throws TransformerConfigurationException {
        TemplatesHandlerImpl handler = new TemplatesHandlerImpl(this._oldOutputSystem);
        handler.init();
        return handler;
    }

    public TransformerHandler newTransformerHandler() throws TransformerConfigurationException {
        Transformer transformer = this.newTransformer();
        TransformerImpl internal = (TransformerImpl)transformer;
        return new TransformerHandlerImpl(internal);
    }

    public TransformerHandler newTransformerHandler(Source src) throws TransformerConfigurationException {
        Transformer transformer = this.newTransformer(src);
        TransformerImpl internal = (TransformerImpl)transformer;
        return new TransformerHandlerImpl(internal);
    }

    public TransformerHandler newTransformerHandler(Templates templates) throws TransformerConfigurationException {
        Transformer transformer = templates.newTransformer();
        TransformerImpl internal = (TransformerImpl)transformer;
        return new TransformerHandlerImpl(internal);
    }

    public XMLFilter newXMLFilter(Source src) throws TransformerConfigurationException {
        Templates templates = this.newTemplates(src);
        if (templates == null) {
            return null;
        }
        return this.newXMLFilter(templates);
    }

    public XMLFilter newXMLFilter(Templates templates) throws TransformerConfigurationException {
        try {
            return new TrAXFilter(templates);
        }
        catch (TransformerConfigurationException e1) {
            if (this._errorListener != null) {
                try {
                    this._errorListener.fatalError(e1);
                    return null;
                }
                catch (TransformerException e2) {
                    new TransformerConfigurationException(e2);
                }
            }
            throw e1;
        }
    }

    public InputSource loadSource(String href, String context, XSLTC xsltc) {
        try {
            Source source = this._uriResolver.resolve(href, context);
            InputSource input = this.getInputSource(xsltc, source);
            return input;
        }
        catch (TransformerConfigurationException e) {
            return null;
        }
        catch (TransformerException e) {
            return null;
        }
    }

    public void error(TransformerException e) throws TransformerException {
        System.err.println("ERROR: " + e.getMessageAndLocation());
        Throwable wrapped = e.getException();
        if (wrapped != null) {
            System.err.println("     : " + wrapped.getMessage());
        }
        throw e;
    }

    public void fatalError(TransformerException e) throws TransformerException {
        System.err.println("FATAL: " + e.getMessageAndLocation());
        Throwable wrapped = e.getException();
        if (wrapped != null) {
            System.err.println("     : " + wrapped.getMessage());
        }
        throw e;
    }

    public void warning(TransformerException e) throws TransformerException {
        System.err.println("WARNING: " + e.getMessageAndLocation());
        Throwable wrapped = e.getException();
        if (wrapped != null) {
            System.err.println("       : " + wrapped.getMessage());
        }
    }

    private class PIParamWrapper {
        public String _media = null;
        public String _title = null;
        public String _charset = null;

        public PIParamWrapper(String media, String title, String charset) {
            this._media = media;
            this._title = title;
            this._charset = charset;
        }
    }
}

