/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.log4j.Category;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSNumber;
import org.pdfbox.cos.COSObject;
import org.pdfbox.cos.COSStream;
import org.pdfbox.cos.COSString;
import org.pdfbox.pdmodel.font.PDFont;
import org.pdfbox.util.Matrix;
import org.pdfbox.util.PDFOperator;
import org.pdfbox.util.TextPosition;

public class PDFStreamEngine {
    private static Category log = Category.getInstance((String)(class$org$pdfbox$util$PDFStreamEngine == null ? (class$org$pdfbox$util$PDFStreamEngine = PDFStreamEngine.class$("org.pdfbox.util.PDFStreamEngine")) : class$org$pdfbox$util$PDFStreamEngine).getName());
    private COSStream stream;
    private Matrix textMatrix = null;
    private Matrix textLineMatrix = null;
    private Matrix currentTransformationMatrix = null;
    private Stack ctmStack = new Stack();
    private float currentLeading = 0.0f;
    private float currentCharacterSpacing = 0.0f;
    private float currentWordSpacing = 0.0f;
    private PDFont currentFont;
    private COSNumber currentFontSize;
    private Map fonts = null;
    static /* synthetic */ Class class$org$pdfbox$util$PDFStreamEngine;

    public void processStream(COSStream cosStream, Map fontMap) throws IOException {
        this.stream = cosStream;
        this.textMatrix = null;
        this.textLineMatrix = null;
        this.currentTransformationMatrix = new Matrix();
        this.ctmStack = new Stack();
        this.currentLeading = 0.0f;
        this.currentCharacterSpacing = 0.0f;
        this.currentWordSpacing = 0.0f;
        this.currentFont = null;
        this.currentFontSize = null;
        this.fonts = fontMap;
        ArrayList<COSBase> arguments = new ArrayList<COSBase>();
        long startTokens = System.currentTimeMillis();
        List tokens = this.stream.getStreamTokens();
        long stopTokens = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Getting tokens time=" + (stopTokens - startTokens)));
        }
        if (tokens != null) {
            Iterator iter = tokens.iterator();
            while (iter.hasNext()) {
                Object next = iter.next();
                if (next instanceof COSObject) {
                    arguments.add(((COSObject)next).getObject());
                    continue;
                }
                if (next instanceof PDFOperator) {
                    this.processOperator((PDFOperator)next, arguments);
                    arguments = new ArrayList();
                    continue;
                }
                arguments.add((COSBase)next);
            }
        }
    }

    protected TextPosition showString(byte[] string) throws IOException {
        float fontSize;
        float xPos = 0.0f;
        float yPos = 0.0f;
        float width = 0.0f;
        float lastCharWidth = fontSize = this.currentFontSize.floatValue();
        float wordSpacing = 0.0f;
        float padding = 0.0f;
        StringBuffer encodedString = new StringBuffer(string.length);
        Matrix textRenderingMatrix = this.textMatrix.multiply(this.currentTransformationMatrix);
        int codeLength = 1;
        int i = 0;
        while (i < string.length) {
            codeLength = 1;
            String c = this.currentFont.encode(string, i, codeLength);
            if (c == null && i + 1 < string.length) {
                c = this.currentFont.encode(string, i, ++codeLength);
            }
            float characterWidth = this.currentFont.getFontWidth(string, i, codeLength) / 1000.0f * fontSize;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Checking code '" + c + "' font=" + this.currentFont + " Tc=" + this.currentCharacterSpacing + " Tw=" + this.currentWordSpacing + " fontSize=" + fontSize + " characterWidth=" + characterWidth));
            }
            if (c != null) {
                encodedString.append(c);
            }
            if (c != null) {
                padding = string[i] == 32 && c.equals(" ") ? this.currentWordSpacing + this.currentCharacterSpacing : this.currentCharacterSpacing;
            }
            if (i == 0) {
                xPos = textRenderingMatrix.getValue(2, 0);
                yPos = textRenderingMatrix.getValue(2, 1);
                byte[] baseWidthChar = new byte[]{110};
                if ("n".equals(this.currentFont.encode(baseWidthChar, 0, 1))) {
                    wordSpacing = this.currentFont.getFontWidth(baseWidthChar, 0, 1) / 1000.0f * fontSize;
                }
                if (wordSpacing == 0.0f) {
                    wordSpacing = characterWidth;
                }
                if (wordSpacing == 0.0f) {
                    wordSpacing = fontSize * 0.075f;
                }
                wordSpacing += this.currentWordSpacing;
            }
            if (characterWidth != 0.0f) {
                lastCharWidth = characterWidth;
            }
            width += characterWidth + padding;
            i += codeLength;
        }
        Matrix td = new Matrix();
        td.setValue(2, 0, width * this.textMatrix.getValue(0, 0));
        this.textMatrix = this.textMatrix.multiply(td);
        float xScale = textRenderingMatrix.getValue(0, 0);
        float yScale = textRenderingMatrix.getValue(1, 1);
        width *= xScale;
        fontSize *= yScale;
        lastCharWidth *= xScale;
        wordSpacing *= xScale;
        padding *= xScale;
        if (log.isDebugEnabled()) {
            log.debug((Object)("TextPosition x=" + xPos + " y=" + yPos + " width=" + width + " string=\"" + encodedString.toString() + "\"" + " fontSize=" + fontSize + " lastCharWidth=" + lastCharWidth + " wordSpacing=" + wordSpacing + " padding=" + padding));
        }
        TextPosition position = new TextPosition(xPos, yPos, width, encodedString.toString(), this.currentFont, fontSize, lastCharWidth, wordSpacing, padding);
        return position;
    }

    protected void processOperator(PDFOperator operator, List arguments) throws IOException {
        String operation = operator.getOperation();
        if (log.isDebugEnabled()) {
            log.debug((Object)("processOperator( '" + operation + "' )"));
        }
        if (operation.equals("BT")) {
            log.debug((Object)"<BT>");
            this.textMatrix = new Matrix();
            this.textLineMatrix = this.textMatrix.copy();
        } else if (operation.equals("cm")) {
            COSNumber a = (COSNumber)arguments.get(0);
            COSNumber b = (COSNumber)arguments.get(1);
            COSNumber c = (COSNumber)arguments.get(2);
            COSNumber d = (COSNumber)arguments.get(3);
            COSNumber e = (COSNumber)arguments.get(4);
            COSNumber f = (COSNumber)arguments.get(5);
            if (log.isDebugEnabled()) {
                log.debug((Object)("<cm a=\"" + a.floatValue() + "\" " + "b=\"" + b.floatValue() + "\" " + "c=\"" + c.floatValue() + "\" " + "d=\"" + d.floatValue() + "\" " + "e=\"" + e.floatValue() + "\" " + "f=\"" + f.floatValue() + "\" >"));
            }
            Matrix newMatrix = new Matrix();
            newMatrix.setValue(0, 0, a.floatValue());
            newMatrix.setValue(0, 1, b.floatValue());
            newMatrix.setValue(1, 0, c.floatValue());
            newMatrix.setValue(1, 1, d.floatValue());
            newMatrix.setValue(2, 0, e.floatValue());
            newMatrix.setValue(2, 1, f.floatValue());
            this.currentTransformationMatrix = this.currentTransformationMatrix.multiply(newMatrix);
        } else if (operation.equals("ET")) {
            log.debug((Object)"<ET>");
            this.textMatrix = null;
            this.textLineMatrix = null;
        } else if (operation.equals("q")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("<" + operation + "> - save state"));
            }
            this.ctmStack.push(this.currentTransformationMatrix);
        } else if (operation.equals("Q")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("<" + operation + "> - restore state"));
            }
            this.currentTransformationMatrix = (Matrix)this.ctmStack.pop();
        } else if (operation.equals("T*")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("<T* currentLeading=\"" + this.currentLeading + "\">"));
            }
            if (this.currentLeading == 0.0f) {
                this.currentLeading = -0.01f;
            }
            Matrix td = new Matrix();
            td.setValue(2, 1, -1.0f * this.currentLeading * this.textMatrix.getValue(1, 1));
            this.textLineMatrix = this.textLineMatrix.multiply(td);
            this.textMatrix = this.textLineMatrix.copy();
        } else if (operation.equals("Tc")) {
            COSNumber characterSpacing = (COSNumber)arguments.get(0);
            if (log.isDebugEnabled()) {
                log.debug((Object)("<Tc characterSpacing=\"" + characterSpacing.floatValue() + "\" />"));
            }
            this.currentCharacterSpacing = characterSpacing.floatValue();
        } else if (operation.equals("Td")) {
            COSNumber x = (COSNumber)arguments.get(0);
            COSNumber y = (COSNumber)arguments.get(1);
            if (log.isDebugEnabled()) {
                log.debug((Object)("<Td x=\"" + x.floatValue() + "\" y=\"" + y.floatValue() + "\">"));
            }
            Matrix td = new Matrix();
            td.setValue(2, 0, x.floatValue() * this.textMatrix.getValue(0, 0));
            td.setValue(2, 1, y.floatValue() * this.textMatrix.getValue(1, 1));
            this.textLineMatrix = this.textLineMatrix.multiply(td);
            this.textMatrix = this.textLineMatrix.copy();
        } else if (operation.equals("TD")) {
            COSNumber x = (COSNumber)arguments.get(0);
            COSNumber y = (COSNumber)arguments.get(1);
            if (log.isDebugEnabled()) {
                log.debug((Object)("<TD x=\"" + x.floatValue() + "\" y=\"" + y.floatValue() + "\">"));
            }
            this.currentLeading = -1.0f * y.floatValue();
            Matrix td = new Matrix();
            td.setValue(2, 0, x.floatValue() * this.textMatrix.getValue(0, 0));
            td.setValue(2, 1, y.floatValue() * this.textMatrix.getValue(1, 1));
            this.textLineMatrix = this.textLineMatrix.multiply(td);
            this.textMatrix = this.textLineMatrix.copy();
        } else if (operation.equals("Tf")) {
            COSName fontName = (COSName)arguments.get(0);
            this.currentFontSize = (COSNumber)arguments.get(1);
            if (log.isDebugEnabled()) {
                log.debug((Object)("<Tf font=\"" + fontName.getName() + "\" size=\"" + this.currentFontSize.floatValue() + "\">"));
            }
            this.currentFont = (PDFont)this.fonts.get(fontName);
            if (this.currentFont == null) {
                throw new IOException("Current font is null");
            }
        } else if (operation.equals("Tj")) {
            COSString string = (COSString)arguments.get(0);
            TextPosition pos = this.showString(string.getBytes());
            if (log.isDebugEnabled()) {
                log.debug((Object)("<Tj string=\"" + string.getString() + "\">"));
            }
        } else if (operation.equals("TJ")) {
            Matrix td = new Matrix();
            COSArray array = (COSArray)arguments.get(0);
            int i = 0;
            while (i < array.size()) {
                COSBase next = array.get(i);
                if (next instanceof COSNumber) {
                    float value = -1.0f * (((COSNumber)next).floatValue() / 1000.0f) * this.currentFontSize.floatValue() * this.textMatrix.getValue(1, 1);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("<TJ(" + i + ") value=\"" + value + "\", param=\"" + ((COSNumber)next).floatValue() + "\", fontsize=\"" + this.currentFontSize.floatValue() + "\">"));
                    }
                    td.setValue(2, 0, value);
                    this.textMatrix = this.textMatrix.multiply(td);
                } else if (next instanceof COSString) {
                    TextPosition pos = this.showString(((COSString)next).getBytes());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("<TJ(" + i + ") string=\"" + pos.getString() + "\">"));
                    }
                } else {
                    throw new IOException("Unknown type in array for TJ operation:" + next);
                }
                ++i;
            }
        } else if (operation.equals("TL")) {
            COSNumber leading = (COSNumber)arguments.get(0);
            this.currentLeading = leading.floatValue();
            if (log.isDebugEnabled()) {
                log.debug((Object)("<TL leading=\"" + leading.floatValue() + "\" >"));
            }
        } else if (operation.equals("Tm")) {
            COSNumber a = (COSNumber)arguments.get(0);
            COSNumber b = (COSNumber)arguments.get(1);
            COSNumber c = (COSNumber)arguments.get(2);
            COSNumber d = (COSNumber)arguments.get(3);
            COSNumber e = (COSNumber)arguments.get(4);
            COSNumber f = (COSNumber)arguments.get(5);
            if (log.isDebugEnabled()) {
                log.debug((Object)("<Tm a=\"" + a.floatValue() + "\" " + "b=\"" + b.floatValue() + "\" " + "c=\"" + c.floatValue() + "\" " + "d=\"" + d.floatValue() + "\" " + "e=\"" + e.floatValue() + "\" " + "f=\"" + f.floatValue() + "\" >"));
            }
            this.textMatrix = new Matrix();
            this.textMatrix.setValue(0, 0, a.floatValue());
            this.textMatrix.setValue(0, 1, b.floatValue());
            this.textMatrix.setValue(1, 0, c.floatValue());
            this.textMatrix.setValue(1, 1, d.floatValue());
            this.textMatrix.setValue(2, 0, e.floatValue());
            this.textMatrix.setValue(2, 1, f.floatValue());
            this.textLineMatrix = this.textMatrix.copy();
        } else if (operation.equals("Tw")) {
            COSNumber wordSpacing = (COSNumber)arguments.get(0);
            if (log.isDebugEnabled()) {
                log.debug((Object)("<Tw wordSpacing=\"" + wordSpacing.floatValue() + "\" />"));
            }
            this.currentWordSpacing = wordSpacing.floatValue();
        } else if (operation.equals("'")) {
            COSString string = (COSString)arguments.get(0);
            if (log.isDebugEnabled()) {
                log.debug((Object)("<' string=\"" + string.getString() + "\">"));
            }
            Matrix td = new Matrix();
            td.setValue(2, 1, -1.0f * this.currentLeading * this.textMatrix.getValue(1, 1));
            this.textLineMatrix = this.textLineMatrix.multiply(td);
            this.textMatrix = this.textLineMatrix.copy();
            this.showString(string.getBytes());
        } else if (operation.equals("\"")) {
            COSNumber wordSpacing = (COSNumber)arguments.get(0);
            COSNumber characterSpacing = (COSNumber)arguments.get(1);
            COSString string = (COSString)arguments.get(2);
            if (log.isDebugEnabled()) {
                log.debug((Object)("<\" wordSpacing=\"" + wordSpacing + "\", characterSpacing=\"" + characterSpacing + "\", string=\"" + string.getString() + "\">"));
            }
            this.currentCharacterSpacing = characterSpacing.floatValue();
            this.currentWordSpacing = wordSpacing.floatValue();
            Matrix td = new Matrix();
            td.setValue(2, 1, -1.0f * this.currentLeading * this.textMatrix.getValue(1, 1));
            this.textLineMatrix = this.textLineMatrix.multiply(td);
            this.textMatrix = this.textLineMatrix.copy();
            this.showString(string.getBytes());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

