/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xpath.expr.function;

import jd.xml.xpath.XPathException;
import jd.xml.xpath.expr.Expression;
import jd.xml.xpath.expr.function.Function;

public class FunctionType {
    public final String name;
    public final int minArgumentCount;
    public final int maxArgumentCount;

    public FunctionType(String string) {
        this(string, 0);
    }

    public FunctionType(String string, int n) {
        this(string, n, n);
    }

    public FunctionType(String string, int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("minArgumentCount cannot be negative");
        }
        if (n2 < n) {
            throw new IllegalArgumentException("maxArgumentCount cannot be less than minArgumentCount");
        }
        this.name = string;
        this.minArgumentCount = n;
        this.maxArgumentCount = n2;
    }

    public boolean checkArgumentCount(int n) {
        return n >= this.minArgumentCount && n <= this.maxArgumentCount;
    }

    public Expression[] normArguments(Expression[] expressionArray) {
        int n;
        int n2 = n = expressionArray == null ? 0 : expressionArray.length;
        if (!this.checkArgumentCount(n)) {
            throw new XPathException("function " + this.name + " does not take " + n + " arguments");
        }
        return n == 0 ? Function.NULL_ARGUMENTS : expressionArray;
    }

    public int getContextDependencies(Expression[] expressionArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < expressionArray.length) {
            n |= expressionArray[n2].getContextDependencies();
            ++n2;
        }
        return n;
    }

    public boolean isFunctionInstance(Expression expression) {
        return expression instanceof Function && ((Function)expression).getFunctionType() == this;
    }

    public Function copyFunction(Function function) throws InstantiationException, ClassNotFoundException, IllegalAccessException {
        return (Function)function.getClass().newInstance();
    }
}

