/*
 * Decompiled with CFR 0.152.
 */
package jd.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.Vector;

public abstract class FileUtil {
    public static void close(InputStream inputStream) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void close(OutputStream outputStream) {
        try {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void close(Writer writer) {
        try {
            if (writer != null) {
                writer.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void close(Reader reader) {
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void copy(Reader reader, Writer writer) throws IOException {
        int n;
        char[] cArray = new char[256];
        while ((n = reader.read(cArray)) != -1) {
            writer.write(cArray, 0, n);
        }
    }

    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[256];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File file, File file2) throws IOException {
        BufferedInputStream bufferedInputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            FileUtil.copy((InputStream)bufferedInputStream, bufferedOutputStream);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            FileUtil.close(bufferedInputStream);
            FileUtil.close(bufferedOutputStream);
            throw throwable;
        }
        FileUtil.close(bufferedInputStream);
        FileUtil.close(bufferedOutputStream);
    }

    public static void copy(Reader reader, StringBuffer stringBuffer) throws IOException {
        int n;
        char[] cArray = new char[256];
        while ((n = reader.read(cArray)) != -1) {
            stringBuffer.append(cArray, 0, n);
        }
    }

    public static void copy(InputStream inputStream, StringBuffer stringBuffer) throws IOException {
        FileUtil.copy((Reader)new InputStreamReader(inputStream), stringBuffer);
    }

    public static String read(InputStream inputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        FileUtil.copy(inputStream, stringBuffer);
        return stringBuffer.toString();
    }

    public static String read(Reader reader) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        FileUtil.copy(reader, stringBuffer);
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(File file) throws IOException {
        String string;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            string = FileUtil.read(bufferedReader);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            FileUtil.close(bufferedReader);
            throw throwable;
        }
        FileUtil.close(bufferedReader);
        return string;
    }

    public static String[] readLines(InputStream inputStream) throws IOException {
        return FileUtil.readLines(inputStream, false);
    }

    public static String[] readLines(InputStream inputStream, boolean bl) throws IOException {
        Vector<String> vector = new Vector<String>();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            if (bl) {
                string = string.trim();
            }
            if (bl && string.length() <= 0) continue;
            vector.addElement(string);
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static String getExtension(File file) {
        return FileUtil.getExtension(file.getName());
    }

    public static String getExtension(String string) {
        int n = string.lastIndexOf(46);
        return n == -1 ? "" : string.substring(n + 1);
    }

    public static String getFileName(File file) {
        String string = file.getName();
        int n = string.lastIndexOf(46);
        return n == -1 ? string : string.substring(0, n);
    }

    public static void deleteDirectoryTree(File file) throws IOException {
        FileUtil.deleteDirectoryContent(file, true);
        if (!file.delete()) {
            throw new IOException("cannot delete '" + file.getAbsolutePath() + "'");
        }
    }

    public static void deleteDirectoryContent(File file, boolean bl) throws IOException {
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("not a directory: " + file);
        }
        String[] stringArray = file.list();
        int n = 0;
        while (n < stringArray.length) {
            File file2 = new File(file, stringArray[n]);
            if (file2.isDirectory() && bl) {
                FileUtil.deleteDirectoryContent(file2, true);
            }
            if (!(file2.isDirectory() && !bl || file2.delete())) {
                throw new IOException("cannot delete '" + file2.getAbsolutePath() + "'");
            }
            ++n;
        }
    }

    public static byte[] serialize(Serializable serializable) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(serializable);
        objectOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static Object deserialize(byte[] byArray) throws IOException, ClassNotFoundException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        return objectInputStream.readObject();
    }

    public static String getLineSeparator() {
        return System.getProperty("line.separator");
    }
}

