/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.contenttypes.ui;


import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentPage;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.contenttypes.Service;
import com.arsdigita.toolbox.ui.DomainObjectPropertySheet;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.cms.ui.authoring.AuthoringKitWizard;
import com.arsdigita.cms.ui.authoring.BasicPageForm;
import com.arsdigita.cms.ui.authoring.SimpleEditStep;
import com.arsdigita.cms.ui.workflow.WorkflowLockedComponentAccess;
import com.arsdigita.cms.util.GlobalizationUtil;

import java.text.DateFormat;

/**
 * Authoring step to edit the simple attributes of the Service content type (and
 * its subclasses). The attributes edited are 'name', 'title', 'summary',
 * 'services provided', 'opening times', 'address', and 'contacts'.  This
 * authoring step replaces the <code>com.arsdigita.ui.authoring.PageEdit</code>
 * step for this type.
 **/
public class ServicePropertiesStep extends SimpleEditStep {

    /** The name of the editing sheet added to this step */
    public static String EDIT_SHEET_NAME = "edit";

    public ServicePropertiesStep(ItemSelectionModel itemModel,
                                 AuthoringKitWizard parent) {

        super(itemModel, parent);

        setDefaultEditKey(EDIT_SHEET_NAME);
        BasicPageForm editSheet;

        editSheet = new ServicePropertyForm(itemModel,this);
        add(EDIT_SHEET_NAME, "Edit", new WorkflowLockedComponentAccess(editSheet, itemModel),
            editSheet.getSaveCancelSection().getCancelButton());

        setDisplayComponent(getServicePropertySheet(itemModel));
    }

    /**
     * Returns a component that displays the properties of the Service specified
     * by the ItemSelectionModel passed in.
     *
     * @param itemModel The ItemSelectionModel to use
     * @pre itemModel != null
     * @return A component to display the state of the basic properties
     *  of the release
     */
    public static Component getServicePropertySheet(ItemSelectionModel
                                                    itemModel) {

        DomainObjectPropertySheet sheet = new DomainObjectPropertySheet(itemModel);

        sheet.add( GlobalizationUtil.globalize("cms.contenttypes.ui.name"),  Service.NAME);
        sheet.add( GlobalizationUtil.globalize("cms.contenttypes.ui.title"),  Service.TITLE);
        if (!ContentSection.getConfig().getHideLaunchDate()) {
            sheet.add(GlobalizationUtil.globalize("cms.contenttypes.ui.launch_date"),
                      ContentPage.LAUNCH_DATE,
                      new DomainObjectPropertySheet.AttributeFormatter() {
                          public String format(DomainObject item,
                                               String attribute,
                                               PageState state) {
                              ContentPage page = (ContentPage) item;
                              if(page.getLaunchDate() != null) {
                                  return DateFormat.getDateInstance(DateFormat.LONG)
                                      .format(page.getLaunchDate());
                              } else {
                                  return (String)GlobalizationUtil.globalize("cms.ui.unknown").localize();
                              }
                          }
                      });
        }
        sheet.add( GlobalizationUtil.globalize("cms.contenttypes.ui.summary"),  Service.SUMMARY);
        sheet.add( GlobalizationUtil.globalize("cms.contenttypes.ui.services_provided"),  Service.SERVICES_PROVIDED);
        sheet.add( GlobalizationUtil.globalize("cms.contenttypes.ui.opening_times"),  Service.OPENING_TIMES);
        sheet.add( GlobalizationUtil.globalize("cms.contenttypes.ui.contacts"),  Service.CONTACTS);

        return sheet;
    }
}
