/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.ContentPage;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.contenttypes.ui.ServicePropertyForm;
import com.arsdigita.cms.ui.authoring.AuthoringKitWizard;
import com.arsdigita.cms.ui.authoring.SimpleEditStep;
import com.arsdigita.cms.ui.workflow.WorkflowLockedComponentAccess;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.kernel.ui.DomainObjectSelectionModel;
import com.arsdigita.toolbox.ui.ComponentAccess;
import com.arsdigita.toolbox.ui.DomainObjectPropertySheet;
import java.text.DateFormat;

public class ServicePropertiesStep
extends SimpleEditStep {
    public static String EDIT_SHEET_NAME = "edit";

    public ServicePropertiesStep(ItemSelectionModel itemModel, AuthoringKitWizard parent) {
        super(itemModel, parent);
        this.setDefaultEditKey(EDIT_SHEET_NAME);
        ServicePropertyForm editSheet = new ServicePropertyForm(itemModel, this);
        this.add(EDIT_SHEET_NAME, "Edit", (ComponentAccess)new WorkflowLockedComponentAccess((Component)editSheet, itemModel), editSheet.getSaveCancelSection().getCancelButton());
        this.setDisplayComponent(ServicePropertiesStep.getServicePropertySheet(itemModel));
    }

    public static Component getServicePropertySheet(ItemSelectionModel itemModel) {
        DomainObjectPropertySheet sheet = new DomainObjectPropertySheet((DomainObjectSelectionModel)itemModel);
        sheet.add(GlobalizationUtil.globalize((String)"cms.contenttypes.ui.name"), "name");
        sheet.add(GlobalizationUtil.globalize((String)"cms.contenttypes.ui.title"), "title");
        if (!ContentSection.getConfig().getHideLaunchDate()) {
            sheet.add(GlobalizationUtil.globalize((String)"cms.contenttypes.ui.launch_date"), "launchDate", new DomainObjectPropertySheet.AttributeFormatter(){

                public String format(DomainObject item, String attribute, PageState state) {
                    ContentPage page = (ContentPage)item;
                    if (page.getLaunchDate() != null) {
                        return DateFormat.getDateInstance(1).format(page.getLaunchDate());
                    }
                    return (String)GlobalizationUtil.globalize((String)"cms.ui.unknown").localize();
                }
            });
        }
        sheet.add(GlobalizationUtil.globalize((String)"cms.contenttypes.ui.summary"), "summary");
        sheet.add(GlobalizationUtil.globalize((String)"cms.contenttypes.ui.services_provided"), "servicesProvided");
        sheet.add(GlobalizationUtil.globalize((String)"cms.contenttypes.ui.opening_times"), "openingTimes");
        sheet.add(GlobalizationUtil.globalize((String)"cms.contenttypes.ui.contacts"), "contacts");
        return sheet;
    }
}

