/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.contenttypes.PressRelease;
import com.arsdigita.cms.contenttypes.ui.PressReleasePropertiesStep;
import com.arsdigita.cms.ui.CMSDHTMLEditor;
import com.arsdigita.cms.ui.authoring.BasicPageForm;
import com.arsdigita.cms.util.GlobalizationUtil;

public class PressReleasePropertyForm
extends BasicPageForm
implements FormProcessListener,
FormInitListener,
FormSubmissionListener {
    private PressReleasePropertiesStep m_step;
    public static final String CONTACT_INFO = "contactInfo";
    public static final String SUMMARY = "summary";
    public static final String REF_CODE = "ref_code";
    public static final String RELEASE_DATE = "rel_date";
    public static final String ID = "press_release_edit";

    public PressReleasePropertyForm(ItemSelectionModel itemModel) {
        this(itemModel, null);
    }

    public PressReleasePropertyForm(ItemSelectionModel itemModel, PressReleasePropertiesStep step) {
        super(ID, itemModel);
        this.m_step = step;
        this.addSubmissionListener(this);
    }

    protected void addWidgets() {
        super.addWidgets();
        this.add((Component)new Label(GlobalizationUtil.globalize((String)"cms.contenttypes.ui.contact_info")));
        StringParameter contactInfoParam = new StringParameter(CONTACT_INFO);
        CMSDHTMLEditor contactInfo = new CMSDHTMLEditor((ParameterModel)contactInfoParam);
        contactInfo.setCols(40);
        contactInfo.setRows(10);
        this.add((Component)contactInfo);
        this.add((Component)new Label(GlobalizationUtil.globalize((String)"cms.contenttypes.ui.summary")));
        StringParameter summaryParam = new StringParameter(SUMMARY);
        TextArea summary = new TextArea((ParameterModel)summaryParam);
        summary.setCols(40);
        summary.setRows(7);
        this.add((Component)summary);
        this.add((Component)new Label(GlobalizationUtil.globalize((String)"cms.contenttypes.ui.reference_code")));
        StringParameter refCodeParam = new StringParameter(REF_CODE);
        TextField refCode = new TextField((ParameterModel)refCodeParam);
        refCode.setSize(30);
        refCode.setMaxLength(30);
        this.add((Component)refCode);
    }

    public void init(FormSectionEvent fse) {
        FormData data = fse.getFormData();
        PressRelease release = (PressRelease)super.initBasicWidgets(fse);
        data.put((Object)CONTACT_INFO, (Object)release.getContactInfo());
        data.put((Object)SUMMARY, (Object)release.getSummary());
        data.put((Object)REF_CODE, (Object)release.getReferenceCode());
    }

    public void submitted(FormSectionEvent fse) {
        if (this.m_step != null && this.getSaveCancelSection().getCancelButton().isSelected(fse.getPageState())) {
            this.m_step.cancelStreamlinedCreation(fse.getPageState());
        }
    }

    public void process(FormSectionEvent fse) {
        FormData data = fse.getFormData();
        PressRelease release = (PressRelease)super.processBasicWidgets(fse);
        if (release != null && this.getSaveCancelSection().getSaveButton().isSelected(fse.getPageState())) {
            release.setReferenceCode((String)data.get((Object)REF_CODE));
            release.setContactInfo((String)data.get((Object)CONTACT_INFO));
            release.setSummary((String)data.get((Object)SUMMARY));
            release.save();
        }
        if (this.m_step != null) {
            this.m_step.maybeForwardToNextStep(fse.getPageState());
        }
    }
}

