/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.cms.contenttypes.Organization;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.ui.authoring.BasicPageForm;
import com.arsdigita.cms.contenttypes.util.OrganizationGlobalizationUtil;


/**
 * Form to edit the basic properties of an Organization. This form can be
 * extended to create forms for Organization subclasses.
 *
 * @version $Id: //cms/content-types/organization/dev/src/com/arsdigita/cms/contenttypes/ui/OrganizationPropertyForm.java#4 $
 */
public class OrganizationPropertyForm
    extends BasicPageForm
    implements FormProcessListener, FormInitListener, FormSubmissionListener {

    private OrganizationPropertiesStep m_step;

    /** parameter names */
    public static final String LINK = "link";
    public static final String CONTACT = "contact";

    /** Name of this form */
    public static final String ID = "Organization_edit";

    /**
     * Creates a new form to edit the Organization object specified
     * by the item selection model passed in.
     * @param itemModel The ItemSelectionModel to use to obtain the
     *    Organization to work on
     */
    public OrganizationPropertyForm( ItemSelectionModel itemModel ) {
        this( itemModel, null );
    }

    /**
     * Creates a new form to edit the Organization object specified
     * by the item selection model passed in.
     * @param itemModel The ItemSelectionModel to use to obtain the
     *    Organization to work on
     * @param step The OrganizationPropertiesStep which controls this form.
     */
    public OrganizationPropertyForm( ItemSelectionModel itemModel, OrganizationPropertiesStep step ) {
        super( ID, itemModel );
        m_step = step;
        addSubmissionListener(this);
    }

    /**
     * Adds widgets to the form.
     */
    protected void addWidgets() {
        super.addWidgets();

        TextField link = new TextField(LINK);
        add(new Label(OrganizationGlobalizationUtil.globalize("cms.contenttypes.link")));
        add(link);

        TextField contact = new TextField(CONTACT);
        add(new Label(OrganizationGlobalizationUtil.globalize("cms.contenttypes.contact")));
        add(contact);

    }

    /** Form initialisation hook. Fills widgets with data. */
    public void init( FormSectionEvent fse ) {
        FormData data = fse.getFormData();
        Organization glossary_item
            = (Organization) super.initBasicWidgets( fse );

        data.put( LINK, glossary_item.getLink() );
        data.put( CONTACT, glossary_item.getContact() );
    }

    /** Cancels streamlined editing. */
    public void submitted( FormSectionEvent fse ) {
        if (m_step != null &&
            getSaveCancelSection().getCancelButton()
            .isSelected( fse.getPageState())) {
            m_step.cancelStreamlinedCreation(fse.getPageState());
        }
    }

    /** Form processing hook. Saves Organization object. */
    public void process( FormSectionEvent fse ) {
        FormData data = fse.getFormData();
        
        Organization glossary_item
            = (Organization) super.processBasicWidgets( fse );

        // save only if save button was pressed
        if( glossary_item != null
            && getSaveCancelSection().getSaveButton()
            .isSelected( fse.getPageState() ) ) {
            glossary_item.setLink( (String) data.get( LINK ) );
            glossary_item.setContact( (String) data.get( CONTACT ) );
            glossary_item.save();
        }
        if (m_step != null) {
            m_step.maybeForwardToNextStep(fse.getPageState());
        }
    }
}
