/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.contenttypes.ui.authoring;

import com.arsdigita.cms.contenttypes.Organization;
import com.arsdigita.cms.contenttypes.util.OrganizationGlobalizationUtil;

import com.arsdigita.cms.Folder;
import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.ui.authoring.PageCreate;
import com.arsdigita.cms.ui.authoring.CreationSelector;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.StringLengthValidationListener;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.PageState;
import com.arsdigita.kernel.KernelHelper;

import java.math.BigDecimal;


/**
 *  The create step for Organization content items.
 *
 *  @author <a href="mailto:dturner@redhat.com">David Turner</a>
 *  @version $Id: //cms/content-types/organization/dev/src/com/arsdigita/cms/contenttypes/ui/authoring/OrganizationCreate.java#4 $
 */
public class OrganizationCreate extends PageCreate {

    public static final String LINK = "link";
    public static final String CONTACT = "contact";

    private CreationSelector m_parent;


    public OrganizationCreate ( ItemSelectionModel itemModel,
                                CreationSelector parent ) {

        super(itemModel, parent);
        m_parent = parent;
    }


    protected void addWidgets () {

        super.addWidgets();

        TextField link = new TextField(LINK);
        add(new Label(OrganizationGlobalizationUtil.globalize("cms.contenttypes.link")));
        add(link);

        TextField contact = new TextField(CONTACT);
        add(new Label(OrganizationGlobalizationUtil.globalize("cms.contenttypes.contact")));
        add(contact);
    }


    public void process ( FormSectionEvent e ) throws FormProcessException {

        FormData data = e.getFormData();
        PageState state = e.getPageState();
        ItemSelectionModel m = getItemSelectionModel();

        // try to get the contact section from the state parameter
        Folder f = m_parent.getFolder(state);
        ContentSection sec = m_parent.getContentSection(state);
        Organization org = (Organization) createContentPage(state);
        org.setLanguage((String) data.get(LANGUAGE));                
        org.setName((String)data.get(NAME));
        org.setTitle((String)data.get(TITLE));
        org.setLink((String)data.get(LINK));
        org.setContact((String)data.get(CONTACT));
        org.save();

        final ContentBundle bundle = new ContentBundle(org);
        bundle.setParent(f);
        bundle.setContentSection(m_parent.getContentSection(state));
        bundle.save();

        // aplaws default workflow
        getWorkflowSection().applyWorkflow(state, org);


        m_parent.editItem(state, org);
    }

}
