/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.cms.contenttypes.Organization;
import com.arsdigita.cms.contenttypes.ui.OrganizationImageForm;
import com.arsdigita.cms.contenttypes.util.OrganizationGlobalizationUtil;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.dispatcher.Utilities;
import com.arsdigita.cms.ui.authoring.BasicPageForm;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.ui.authoring.AuthoringKitWizard;
import com.arsdigita.cms.ui.authoring.SimpleEditStep;
import com.arsdigita.toolbox.ui.DomainObjectPropertySheet;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.toolbox.ui.DomainObjectPropertySheet;
import com.arsdigita.cms.ui.authoring.WorkflowLockedComponentAccess;
import com.arsdigita.cms.ImageAsset;

import java.math.BigDecimal;


/**
 * Authoring step to assign an image to the Organization content 
 * type (and its subclasses). 
 *
 * @version $Id: //cms/content-types/organization/dev/src/com/arsdigita/cms/contenttypes/ui/OrganizationImageStep.java#5 $
 */
public class OrganizationImageStep
    extends SimpleEditStep {

    /** The name of the editing sheet added to this step */
    public static String IMAGE_SHEET_NAME = "image";

    public OrganizationImageStep( ItemSelectionModel itemModel,
				  AuthoringKitWizard parent ) {
	super( itemModel, parent, "_image" );

    setDefaultEditKey(IMAGE_SHEET_NAME);
	add( IMAGE_SHEET_NAME, "Change", new WorkflowLockedComponentAccess(new OrganizationImageForm("OrganizationImageForm", itemModel, this), itemModel));   

	DomainObjectPropertySheet sheet = new DomainObjectPropertySheet(itemModel, false);
	sheet.add(OrganizationGlobalizationUtil.globalize
              ("cms.contenttypes.image"), Organization.IMAGE, new ImageFormatter());

	setDisplayComponent( sheet );
    }


    public static class ImageFormatter
        implements DomainObjectPropertySheet.AttributeFormatter {

        private String m_default;

        public ImageFormatter() {
            this("<i>no image</i>");
        }

        public ImageFormatter(String def) {
            m_default = def;
        }

        public String getDefaultString() {
            return m_default;
        }

        public String format (DomainObject obj,
                              String attribute,
                              PageState state) {

            DataObject imageDO = (DataObject) ((ContentItem)obj).get(attribute);
            if (imageDO == null) {
                return getDefaultString();
            } else {
                ImageAsset image = new ImageAsset(imageDO);
                return getHTMLDisplay(image);
            }
        }

        public static String getHTMLDisplay(ImageAsset image) {
            if (image == null)
                return ("<i>no image</i>");

            BigDecimal width = image.getWidth();
            String widthStr = "";
            if ( width != null ) {
                widthStr = " width=\"" + width.toString() + "\" ";
            }
            BigDecimal height = image.getHeight();
            String heightStr = "";
            if ( height != null ) {
                heightStr = " height=\"" + height.toString() + "\" ";
            }

            String labelStr = "<img src=\"" +
                Utilities.getImageURL(image) +
                "\" " + widthStr + heightStr + "/>";
            return labelStr;
        }
    }

}
