/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.contenttypes;

import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.ContentPage;
import com.arsdigita.cms.ImageAsset;
import com.arsdigita.util.Assert;
import java.math.BigDecimal;


/**
 * This content type represents an Organization.
 *
 * @author <a href="mailto:dturner@redhat.com">David Turner</a>
 * @version $Id: //cms/content-types/organization/dev/src/com/arsdigita/cms/contenttypes/Organization.java#6 $
 */
public class Organization extends ContentPage {

    /** PDL property names */
    public static final String LINK = "link";
    public static final String CONTACT = "contact";
    public static final String IMAGE = "image";
    public static final String IMAGE_ID = "imageID";

    /** Data object type for tihs domain object */
    public static final String BASE_DATA_OBJECT_TYPE
        = "com.arsdigita.cms.contenttypes.Organization";

    public Organization () {
        super(BASE_DATA_OBJECT_TYPE);
    }

    public Organization ( BigDecimal id )
            throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, id));
    }

    public Organization ( OID id )
            throws DataObjectNotFoundException {
        super(id);
    }

    public Organization ( DataObject obj ) {
        super(obj);
    }

    public Organization ( String type ) {
        super(type);
    }

    public void beforeSave() {
        super.beforeSave();
        
        Assert.exists(getContentType(), ContentType.class);
    }


    ///////////////////////////////////////////////////////////////
    // accessors

    public String getLink () {
        return (String)get(LINK);
    }

    public void setLink ( String link ) {
        set(LINK, link);
    }


    public String getContact () {
        return (String)get(CONTACT);
    }

    public void setContact ( String contact ) {
        set(CONTACT, contact);
    }

    public BigDecimal getImageID() {
        return (BigDecimal)get(IMAGE_ID);
    }

    public ImageAsset getImage() {
        DataObject obj = (DataObject)get(IMAGE);
        if ( obj == null ) {
            return null;
        }
        return new ImageAsset(obj);
    }

    public void setImage(ImageAsset image) {
        if (image != null)
            image.setMaster(this);
        setAssociation(IMAGE,image);
    }


    public void delete() {
        ImageAsset image = getImage();
        if (image != null) {
            setAssociation(IMAGE, null);
            save();
            image.delete();
        }

        super.delete();
    }
}
