/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.RadioGroup;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.parameters.DateParameter;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.contenttypes.NewsItem;
import com.arsdigita.cms.contenttypes.ui.NewsItemPropertiesStep;
import com.arsdigita.cms.ui.authoring.BasicPageForm;
import com.arsdigita.cms.util.GlobalizationUtil;
import java.util.Date;

public class NewsItemPropertyForm
extends BasicPageForm
implements FormProcessListener,
FormInitListener,
FormSubmissionListener {
    private NewsItemPropertiesStep m_step;
    public static final String LEAD = "lead";
    public static final String NEWS_DATE = "news_date";
    public static final String IS_HOMEPAGE = "isHomepage";
    public static final String ID = "news_item_edit";

    public NewsItemPropertyForm(ItemSelectionModel itemModel) {
        this(itemModel, null);
    }

    public NewsItemPropertyForm(ItemSelectionModel itemModel, NewsItemPropertiesStep step) {
        super(ID, itemModel);
        this.m_step = step;
        this.addSubmissionListener(this);
    }

    protected void addWidgets() {
        super.addWidgets();
        this.add((Component)new Label(GlobalizationUtil.globalize((String)"cms.contenttypes.ui.lead")));
        StringParameter leadParam = new StringParameter(LEAD);
        TextArea lead = new TextArea((ParameterModel)leadParam);
        lead.setCols(40);
        lead.setRows(5);
        this.add((Component)lead);
        if (!NewsItem.getConfig().getHideHomepageField()) {
            RadioGroup homepageWidget = new RadioGroup(IS_HOMEPAGE);
            homepageWidget.addOption(new Option("true", (Component)new Label(GlobalizationUtil.globalize((String)"yes"))));
            homepageWidget.addOption(new Option("false", (Component)new Label(GlobalizationUtil.globalize((String)"no"))));
            this.add((Component)new Label(GlobalizationUtil.globalize((String)"cms.contenttypes.ui.homepage")));
            this.add((Component)homepageWidget);
        }
        this.add((Component)new Label(GlobalizationUtil.globalize((String)"cms.contenttypes.ui.date")));
        DateParameter newsDateParam = new DateParameter(NEWS_DATE);
        newsDateParam.addParameterListener((ParameterListener)new NotNullValidationListener());
        com.arsdigita.bebop.form.Date newsDate = new com.arsdigita.bebop.form.Date((ParameterModel)newsDateParam);
        this.add((Component)newsDate);
    }

    public void init(FormSectionEvent fse) {
        FormData data = fse.getFormData();
        NewsItem item = (NewsItem)super.initBasicWidgets(fse);
        Date newsDate = item.getNewsDate();
        if (newsDate == null) {
            newsDate = new Date();
        }
        data.put((Object)NEWS_DATE, (Object)newsDate);
        data.put((Object)LEAD, (Object)item.getLead());
        if (!NewsItem.getConfig().getHideHomepageField()) {
            data.put((Object)IS_HOMEPAGE, (Object)item.isHomepage());
        }
    }

    public void submitted(FormSectionEvent fse) {
        if (this.m_step != null && this.getSaveCancelSection().getCancelButton().isSelected(fse.getPageState())) {
            this.m_step.cancelStreamlinedCreation(fse.getPageState());
        }
    }

    public void process(FormSectionEvent fse) {
        FormData data = fse.getFormData();
        NewsItem item = (NewsItem)super.processBasicWidgets(fse);
        if (item != null && this.getSaveCancelSection().getSaveButton().isSelected(fse.getPageState())) {
            item.setNewsDate((Date)data.get((Object)NEWS_DATE));
            item.setLead((String)data.get((Object)LEAD));
            if (!NewsItem.getConfig().getHideHomepageField()) {
                String isHomepage = (String)data.get((Object)IS_HOMEPAGE);
                item.setIsHomepage(new Boolean(isHomepage));
            }
            item.save();
        }
        if (this.m_step != null) {
            this.m_step.maybeForwardToNextStep(fse.getPageState());
        }
    }
}

