/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes;

import com.arsdigita.cms.Article;
import com.arsdigita.cms.contenttypes.NewsItemConfig;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.Assert;
import com.arsdigita.util.StringUtils;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Date;

public class NewsItem
extends Article {
    public static final String LEAD = "lead";
    public static final String NEWS_DATE = "newsDate";
    public static final String IS_HOMEPAGE = "isHomepage";
    public static final String RECENT_NEWS = "com.arsdigita.cms.contenttypes.RecentNews";
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.contenttypes.NewsItem";
    private static final NewsItemConfig s_config = new NewsItemConfig();
    public static final int SUMMARY_LENGTH = 200;
    static /* synthetic */ Class class$com$arsdigita$cms$ContentType;

    public static final NewsItemConfig getConfig() {
        return s_config;
    }

    public NewsItem() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    public NewsItem(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public NewsItem(OID id) throws DataObjectNotFoundException {
        super(id);
    }

    public NewsItem(DataObject obj) {
        super(obj);
    }

    public NewsItem(String type) {
        super(type);
    }

    public void initialize() {
        super.initialize();
        if (this.isNew()) {
            this.setIsHomepage(Boolean.FALSE);
        }
    }

    public void beforeSave() {
        super.beforeSave();
        Assert.exists((Object)this.getContentType(), (Class)(class$com$arsdigita$cms$ContentType == null ? (class$com$arsdigita$cms$ContentType = NewsItem.class$("com.arsdigita.cms.ContentType")) : class$com$arsdigita$cms$ContentType));
    }

    public String getLead() {
        return (String)this.get(LEAD);
    }

    public void setLead(String lead) {
        this.set(LEAD, lead);
    }

    public Boolean isHomepage() {
        Boolean isHomepage = (Boolean)this.get(IS_HOMEPAGE);
        return isHomepage;
    }

    public void setIsHomepage(Boolean isHomePage) {
        this.set(IS_HOMEPAGE, isHomePage);
    }

    public Date getNewsDate() {
        return (Date)this.get(NEWS_DATE);
    }

    public String getDisplayNewsDate() {
        Date d = this.getNewsDate();
        return d != null ? DateFormat.getDateInstance(1).format(d) : null;
    }

    public void setNewsDate(Date newsDate) {
        this.set(NEWS_DATE, newsDate);
    }

    public String getSearchSummary() {
        return StringUtils.truncateString((String)this.getLead(), (int)200, (boolean)true);
    }

    public static NewsItem getMostRecentNewsItem() {
        DataQuery newsItems = SessionManager.getSession().retrieveQuery(RECENT_NEWS);
        NewsItem newsItem = null;
        if (newsItems.next()) {
            try {
                newsItem = new NewsItem((BigDecimal)newsItems.get("newsID"));
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        newsItems.close();
        return newsItem;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        s_config.load();
    }
}

