/*
 * Copyright (C) 2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.contenttypes;

import com.arsdigita.runtime.AbstractConfig;
import com.arsdigita.util.parameter.Parameter;
import com.arsdigita.util.parameter.BooleanParameter;

public class NewsItemConfig extends AbstractConfig {
    
    private final Parameter m_hideHomepageField;

    public NewsItemConfig() {
        m_hideHomepageField = new BooleanParameter(
            "com.arsdigita.cms.contenttypes.newsitem.hide_homepage",
            Parameter.REQUIRED,
            new Boolean(false));
        
        register(m_hideHomepageField);

        loadInfo();
    }
    
    public final boolean getHideHomepageField() {
        return ((Boolean) get(m_hideHomepageField)).booleanValue();
    }

}
