/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.contenttypes;

import com.arsdigita.domain.DomainCollection;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.PersistenceException;

/**
 * This class contains a collection of ArticleSections.
 *
 * @author <a href="mailto:hbrock@redhat.com">Hugh Brock</a>
 *  
 * @see DomainCollection
 * @see DataCollection
 */
public class ArticleSectionCollection extends DomainCollection {

    public static final String versionId = "$Id: //cms/content-types/mparticle/dev/src/com/arsdigita/cms/contenttypes/ArticleSectionCollection.java#3 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * Constructor.
     *
     **/
    public ArticleSectionCollection(DataCollection dataCollection) {
        super(dataCollection);
    }

    /**
     * Set the order of this Collection. This method needs to be called
     * before <code>next()</code> is called on this collection.
     *
     */
    public void addOrder(String order) {
        m_dataCollection.addOrder(order);
    }

    /**
     * Returns a <code>DomainObject</code> for the current position in
     * the collection.
     *
     **/
    public DomainObject getDomainObject() {
        return new ArticleSection(m_dataCollection.getDataObject());
    }

    /**
     * Returns a <code>Image</code> for the current position in
     * the collection.
     *
     **/
    public ArticleSection getArticleSection() {
        return (ArticleSection) getDomainObject();
    }

    // Exposed methods
    public Filter addFilter(String conditions) {
        return m_dataCollection.addFilter(conditions);
    }

    public void clearFilter() {
        m_dataCollection.clearFilter();
    }

    public void clearOrder() throws PersistenceException {
        m_dataCollection.clearOrder();
    }



}
