/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui.mparticle;

import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.CMSContext;
import com.arsdigita.cms.CMSExcursion;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.contenttypes.ArticleSection;
import com.arsdigita.cms.contenttypes.ArticleSectionCollection;
import com.arsdigita.cms.contenttypes.MultiPartArticle;
import com.arsdigita.cms.dispatcher.XMLGenerator;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.xml.Element;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class ArticleSectionPanel
extends SimpleComponent {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$contenttypes$ui$mparticle$ArticleSectionPanel == null ? (class$com$arsdigita$cms$contenttypes$ui$mparticle$ArticleSectionPanel = ArticleSectionPanel.class$("com.arsdigita.cms.contenttypes.ui.mparticle.ArticleSectionPanel")) : class$com$arsdigita$cms$contenttypes$ui$mparticle$ArticleSectionPanel));
    private PageParameter m_page = new PageParameter("page");
    private boolean m_showAllSections = false;
    public static final String PAGE_NUMBER_PARAM = "page";
    public static final String versionId = "$Id: //cms/content-types/mparticle/dev/src/com/arsdigita/cms/contenttypes/ui/mparticle/ArticleSectionPanel.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    static /* synthetic */ Class class$com$arsdigita$cms$contenttypes$ui$mparticle$ArticleSectionPanel;
    static /* synthetic */ Class class$com$arsdigita$cms$contenttypes$ui$mparticle$ArticleSectionPanel$PageNumber;

    public void register(Page p) {
        super.register(p);
        p.addGlobalStateParam((ParameterModel)this.m_page);
    }

    protected XMLGenerator getXMLGenerator(PageState state) {
        ContentSection section = CMS.getContext().getContentSection();
        return section.getXMLGenerator();
    }

    public void setShowAllSections(boolean showAll) {
        this.m_showAllSections = showAll;
    }

    protected ContentItem getContentItem(PageState state) {
        CMSContext context = CMS.getContext();
        if (!context.hasContentItem()) {
            return null;
        }
        return context.getContentItem();
    }

    protected ArticleSection[] getSections(PageState state) {
        PageNumber number = (PageNumber)state.getValue((ParameterModel)this.m_page);
        if (number == null) {
            number = new PageNumber("1");
        }
        MultiPartArticle mpa = (MultiPartArticle)this.getContentItem(state);
        if (!number.wantAllSections()) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Page number requested is " + number.getPageNumber()));
            }
            return this.getSections(state, number.getPageNumber());
        }
        ArticleSectionCollection sections = mpa.getSections();
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)"No page number provided");
        }
        ArticleSection[] page = new ArticleSection[(int)sections.size()];
        int i = 0;
        while (sections.next()) {
            page[i] = sections.getArticleSection();
            ++i;
        }
        return page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArticleSection[] getSections(PageState state, Integer number) {
        ArrayList<ArticleSection> page;
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Getting page " + number));
        }
        MultiPartArticle mpa = (MultiPartArticle)this.getContentItem(state);
        ArticleSectionCollection sections = mpa.getSections();
        int current = 1;
        int desired = number;
        try {
            while (current < desired) {
                if (!sections.next()) {
                    if (s_log.isDebugEnabled()) {
                        s_log.debug((Object)"Hit end of section list");
                    }
                    ArticleSection[] articleSectionArray = new ArticleSection[]{};
                    return articleSectionArray;
                }
                ArticleSection section = sections.getArticleSection();
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("Skipping " + section.getOID()));
                }
                if (!section.isPageBreak()) continue;
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)"Got page break");
                }
                ++current;
            }
            int subsequent = desired + 1;
            page = new ArrayList<ArticleSection>();
            while (current < subsequent) {
                if (!sections.next()) {
                    if (s_log.isDebugEnabled()) {
                        s_log.debug((Object)"Got end of pages, returning.");
                    }
                    break;
                }
                ArticleSection section = sections.getArticleSection();
                page.add(section);
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("Keeping section " + section.getOID()));
                }
                if (!section.isPageBreak()) continue;
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)"Got page break");
                }
                ++current;
            }
        }
        finally {
            sections.close();
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("All done " + page.size() + " sections found"));
        }
        return page.toArray(new ArticleSection[page.size()]);
    }

    public void generateXML(PageState state, Element parent) {
        ContentItem item = this.getContentItem(state);
        if (!this.isVisible(state) || item == null || !(item instanceof MultiPartArticle)) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Skipping generate XML isVisible: " + this.isVisible(state) + " item " + (item == null ? null : item.getOID())));
            }
            return;
        }
        Element content = parent.newChildElement("cms:articleSectionPanel", "http://www.arsdigita.com/cms/1.0");
        this.exportAttributes(content);
        XMLGenerator xmlGenerator = this.getXMLGenerator(state);
        ArticleSection[] sections = this.getSections(state);
        for (int i = 0; i < sections.length; ++i) {
            this.generateSectionXML(state, content, (ContentItem)sections[i], xmlGenerator);
        }
    }

    protected void generateSectionXML(final PageState state, final Element parent, final ContentItem section, final XMLGenerator xmlGenerator) {
        CMSExcursion excursion = new CMSExcursion(){

            public void excurse() {
                this.setContentItem(section);
                xmlGenerator.generateXML(state, parent, null);
            }
        };
        try {
            excursion.run();
        }
        catch (ServletException ex) {
            throw new UncheckedWrapperException("excursion failed", (Throwable)ex);
        }
        catch (IOException ex) {
            throw new UncheckedWrapperException("excursion failed", (Throwable)ex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class PageParameter
    extends ParameterModel {
        public static final String versionId = "$Id: //cms/content-types/mparticle/dev/src/com/arsdigita/cms/contenttypes/ui/mparticle/ArticleSectionPanel.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

        public PageParameter(String name) {
            super(name);
        }

        public Object transformValue(HttpServletRequest request) throws IllegalArgumentException {
            return this.transformSingleValue(request);
        }

        public Object unmarshal(String encoded) throws IllegalArgumentException {
            if (encoded == null || encoded.length() == 0) {
                return null;
            }
            try {
                return new PageNumber(encoded);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                throw new IllegalArgumentException(this.getName() + " should be a BigDecimal: '" + encoded + "'");
            }
        }

        public Class getValueClass() {
            return class$com$arsdigita$cms$contenttypes$ui$mparticle$ArticleSectionPanel$PageNumber == null ? (class$com$arsdigita$cms$contenttypes$ui$mparticle$ArticleSectionPanel$PageNumber = ArticleSectionPanel.class$("com.arsdigita.cms.contenttypes.ui.mparticle.ArticleSectionPanel$PageNumber")) : class$com$arsdigita$cms$contenttypes$ui$mparticle$ArticleSectionPanel$PageNumber;
        }
    }

    private class PageNumber {
        private boolean m_all;
        private Integer m_number;

        public PageNumber(String number) throws NumberFormatException {
            if ("all".equals(number.toLowerCase())) {
                this.m_all = true;
                this.m_number = null;
            } else {
                this.m_all = false;
                this.m_number = new Integer(number);
            }
        }

        public boolean wantAllSections() {
            return this.m_all;
        }

        public Integer getPageNumber() {
            return this.m_number;
        }
    }
}

