/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui.mparticle;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.event.TableActionListener;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableColumn;
import com.arsdigita.bebop.table.TableColumnModel;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.SecurityManager;
import com.arsdigita.cms.contenttypes.ArticleSection;
import com.arsdigita.cms.contenttypes.ArticleSectionCollection;
import com.arsdigita.cms.contenttypes.MultiPartArticle;
import com.arsdigita.cms.dispatcher.Utilities;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.LockableImpl;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class SectionTable
extends Table {
    private static final Logger log = Logger.getLogger((String)(class$com$arsdigita$cms$contenttypes$ui$mparticle$SectionTable == null ? (class$com$arsdigita$cms$contenttypes$ui$mparticle$SectionTable = SectionTable.class$("com.arsdigita.cms.contenttypes.ui.mparticle.SectionTable")) : class$com$arsdigita$cms$contenttypes$ui$mparticle$SectionTable).getName());
    public static final String COL_TITLE = "Section";
    public static final String COL_EDIT = "Edit";
    public static final String COL_MOVE = "Move";
    public static final String COL_DEL = "Delete";
    private ItemSelectionModel m_selArticle;
    private ItemSelectionModel m_selSection;
    private ItemSelectionModel m_moveSection;
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$contenttypes$ui$mparticle$SectionTable == null ? (class$com$arsdigita$cms$contenttypes$ui$mparticle$SectionTable = SectionTable.class$("com.arsdigita.cms.contenttypes.ui.mparticle.SectionTable")) : class$com$arsdigita$cms$contenttypes$ui$mparticle$SectionTable));
    static /* synthetic */ Class class$com$arsdigita$cms$contenttypes$ui$mparticle$SectionTable;

    public SectionTable(ItemSelectionModel selArticle, ItemSelectionModel moveSection) {
        this.m_selArticle = selArticle;
        this.m_moveSection = moveSection;
        TableColumnModel model = this.getColumnModel();
        model.add(new TableColumn(0, (Object)COL_TITLE));
        model.add(new TableColumn(1, (Object)COL_EDIT));
        model.add(new TableColumn(2, (Object)COL_MOVE));
        model.add(new TableColumn(3, (Object)COL_DEL));
        model.get(1).setCellRenderer((TableCellRenderer)new SectionTableCellRenderer(true));
        model.get(2).setCellRenderer((TableCellRenderer)new SectionTableCellRenderer(true));
        model.get(3).setCellRenderer((TableCellRenderer)new SectionTableCellRenderer(true));
        this.setModelBuilder(new SectionTableModelBuilder(this.m_selArticle, this.m_moveSection));
        this.addTableActionListener(new TableActionListener(){

            public void cellSelected(TableActionEvent event) {
                PageState state = event.getPageState();
                TableColumn col = SectionTable.this.getColumnModel().get(event.getColumn().intValue());
                String colName = (String)col.getHeaderValue();
                if (SectionTable.COL_MOVE.equals(colName)) {
                    if (SectionTable.this.m_moveSection.getSelectedKey(state) == null) {
                        SectionTable.this.m_moveSection.setSelectedKey(state, SectionTable.this.m_selSection.getSelectedKey(state));
                    } else {
                        MultiPartArticle article = (MultiPartArticle)SectionTable.this.m_selArticle.getSelectedObject(state);
                        BigDecimal id = (BigDecimal)SectionTable.this.m_moveSection.getSelectedKey(state);
                        ArticleSection sect = (ArticleSection)DomainObjectFactory.newInstance((OID)new OID("com.arsdigita.cms.contenttypes.ArticleSection", (Object)id));
                        BigDecimal dest = new BigDecimal((String)event.getRowKey());
                        ArticleSection destSect = (ArticleSection)DomainObjectFactory.newInstance((OID)new OID("com.arsdigita.cms.contenttypes.ArticleSection", (Object)dest));
                        int rank = destSect.getRank();
                        if (sect.getRank() > rank) {
                            ++rank;
                        }
                        article.changeSectionRank(sect, rank);
                        SectionTable.this.m_moveSection.setSelectedKey(state, null);
                    }
                }
            }

            public void headSelected(TableActionEvent event) {
            }
        });
    }

    public void setSectionModel(ItemSelectionModel selSection) {
        if (selSection == null) {
            s_log.warn((Object)"null item model");
        }
        this.m_selSection = selSection;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class SectionTableCellRenderer
    extends LockableImpl
    implements TableCellRenderer {
        private boolean m_active;

        public SectionTableCellRenderer() {
            this(false);
        }

        public SectionTableCellRenderer(boolean active) {
            this.m_active = active;
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            boolean active;
            Object ret = null;
            SecurityManager sm = Utilities.getSecurityManager((PageState)state);
            ContentItem item = (ContentItem)SectionTable.this.m_selArticle.getSelectedObject(state);
            boolean bl = active = this.m_active && sm.canAccess(state.getRequest(), "edit_item", item);
            ret = value instanceof Component ? (Component)value : (value == null ? new Label("", false) : (active ? new ControlLink(value.toString()) : new Label(value.toString())));
            return ret;
        }
    }

    protected class SectionTableModel
    implements TableModel {
        private TableColumnModel m_colModel;
        private SectionTable m_table;
        private PageState m_state;
        private ArticleSectionCollection m_sections;
        private ItemSelectionModel m_moveSection;
        private ArticleSection m_section;

        public SectionTableModel(Table table, PageState state, MultiPartArticle article, ItemSelectionModel moveSection) {
            this.m_colModel = table.getColumnModel();
            this.m_state = state;
            this.m_sections = article.getSections();
            this.m_table = (SectionTable)table;
            this.m_moveSection = moveSection;
        }

        public int getColumnCount() {
            return this.m_colModel.size();
        }

        public boolean nextRow() {
            if (this.m_sections.next()) {
                this.m_section = this.m_sections.getArticleSection();
                return true;
            }
            return false;
        }

        public Object getElementAt(int columnIndex) {
            if (this.m_colModel == null) {
                return null;
            }
            TableColumn col = this.m_colModel.get(columnIndex);
            String colName = (String)col.getHeaderValue();
            if (SectionTable.COL_TITLE.equals(colName)) {
                return this.m_section.getTitle();
            }
            if (SectionTable.COL_EDIT.equals(colName)) {
                return "edit";
            }
            if (SectionTable.COL_DEL.equals(colName)) {
                return "delete";
            }
            if (SectionTable.COL_MOVE.equals(colName)) {
                if (this.m_moveSection.getSelectedKey(this.m_state) == null) {
                    return "move";
                }
                return "move below here";
            }
            return null;
        }

        public Object getKeyAt(int columnIndex) {
            return this.m_section.getID();
        }
    }

    protected class SectionTableModelBuilder
    extends LockableImpl
    implements TableModelBuilder {
        protected ItemSelectionModel m_selArticle;
        protected ItemSelectionModel m_moveSection;

        public SectionTableModelBuilder(ItemSelectionModel selArticle, ItemSelectionModel moveSection) {
            this.m_selArticle = selArticle;
            this.m_moveSection = moveSection;
        }

        public TableModel makeModel(Table table, PageState state) {
            table.getRowSelectionModel().clearSelection(state);
            MultiPartArticle article = (MultiPartArticle)this.m_selArticle.getSelectedObject(state);
            return new SectionTableModel(table, state, article, this.m_moveSection);
        }
    }
}

