/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui.mparticle;

import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SaveCancelSection;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.CheckboxGroup;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.TrimmedStringParameter;
import com.arsdigita.cms.ImageAsset;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.TextAsset;
import com.arsdigita.cms.contenttypes.ArticleSection;
import com.arsdigita.cms.contenttypes.MultiPartArticle;
import com.arsdigita.cms.contenttypes.ui.mparticle.ImageUploadSection;
import com.arsdigita.cms.contenttypes.ui.mparticle.MultiPartArticleViewSections;
import com.arsdigita.cms.contenttypes.util.MPArticleGlobalizationUtil;
import com.arsdigita.cms.ui.CMSDHTMLEditor;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class SectionEditForm
extends Form {
    private static final Logger log = Logger.getLogger((Class)(class$com$arsdigita$cms$contenttypes$ui$mparticle$SectionEditForm == null ? (class$com$arsdigita$cms$contenttypes$ui$mparticle$SectionEditForm = SectionEditForm.class$("com.arsdigita.cms.contenttypes.ui.mparticle.SectionEditForm")) : class$com$arsdigita$cms$contenttypes$ui$mparticle$SectionEditForm));
    private ItemSelectionModel m_selArticle;
    private ItemSelectionModel m_selSection;
    private BigDecimalParameter m_imageParam;
    private ItemSelectionModel m_selImage;
    private BigDecimalParameter m_textParam;
    private ItemSelectionModel m_selText;
    private MultiPartArticleViewSections m_container;
    private SaveCancelSection m_saveCancelSection;
    private ImageUploadSection m_imageUpload;
    public static final String TITLE = "title";
    public static final String TEXT = "text";
    public static final String IMAGE = "image";
    public static final String PAGE_BREAK = "pageBreak";
    private static final String TEXT_PARAM = "textParam";
    private static final String IMAGE_PARAM = "imageParam";
    static /* synthetic */ Class class$com$arsdigita$cms$contenttypes$ui$mparticle$SectionEditForm;
    static /* synthetic */ Class class$com$arsdigita$cms$ImageAsset;
    static /* synthetic */ Class class$com$arsdigita$cms$TextAsset;

    public SectionEditForm(ItemSelectionModel selArticle, ItemSelectionModel selSection) {
        this(selArticle, selSection, null);
    }

    public SectionEditForm(ItemSelectionModel selArticle, ItemSelectionModel selSection, MultiPartArticleViewSections container) {
        super("SectionEditForm", (Container)new ColumnPanel(2));
        this.m_selArticle = selArticle;
        this.m_selSection = selSection;
        this.m_container = container;
        this.m_imageParam = new BigDecimalParameter(IMAGE_PARAM);
        this.m_selImage = new ItemSelectionModel((class$com$arsdigita$cms$ImageAsset == null ? (class$com$arsdigita$cms$ImageAsset = SectionEditForm.class$("com.arsdigita.cms.ImageAsset")) : class$com$arsdigita$cms$ImageAsset).getName(), "com.arsdigita.cms.ImageAsset", this.m_imageParam);
        this.m_textParam = new BigDecimalParameter(TEXT_PARAM);
        this.m_selText = new ItemSelectionModel((class$com$arsdigita$cms$TextAsset == null ? (class$com$arsdigita$cms$TextAsset = SectionEditForm.class$("com.arsdigita.cms.TextAsset")) : class$com$arsdigita$cms$TextAsset).getName(), "com.arsdigita.cms.TextAsset", this.m_textParam);
        this.setMethod("post");
        this.setEncType("multipart/form-data");
        ColumnPanel panel = (ColumnPanel)this.getPanel();
        panel.setBorder(false);
        panel.setPadColor("#FFFFFF");
        panel.setColumnWidth(1, "20%");
        panel.setColumnWidth(2, "80%");
        panel.setWidth("100%");
        this.addWidgets();
        this.addSaveCancelSection();
        this.addInitListener(new SectionInitListener());
        this.addSubmissionListener(new SectionSubmissionListener());
        this.addProcessListener(new SectionProcessListener());
    }

    protected SaveCancelSection addSaveCancelSection() {
        this.m_saveCancelSection = new SaveCancelSection();
        this.add((Component)this.m_saveCancelSection, 65);
        return this.m_saveCancelSection;
    }

    public SaveCancelSection getSaveCancelSection() {
        return this.m_saveCancelSection;
    }

    protected void addWidgets() {
        this.add((Component)new Label(MPArticleGlobalizationUtil.globalize("cms.contenttypes.ui.mparticle.title")));
        TextField titleWidget = new TextField((ParameterModel)new TrimmedStringParameter(TITLE));
        titleWidget.addValidationListener((ParameterListener)new NotNullValidationListener());
        this.add((Component)titleWidget);
        this.add((Component)new Label(MPArticleGlobalizationUtil.globalize("cms.contenttypes.ui.mparticle.body_text")), 65);
        CMSDHTMLEditor textWidget = new CMSDHTMLEditor((ParameterModel)new TrimmedStringParameter(TEXT));
        textWidget.setRows(40);
        textWidget.setCols(70);
        textWidget.setWrap(2);
        this.add((Component)textWidget, 65);
        this.add((Component)new Label(MPArticleGlobalizationUtil.globalize("cms.contenttypes.ui.mparticle.image")), 65);
        this.m_imageUpload = new ImageUploadSection(IMAGE, this.m_selImage);
        this.add((Component)this.m_imageUpload, 65);
        this.add((Component)new Label(""));
        CheckboxGroup pageBreak = new CheckboxGroup(PAGE_BREAK);
        pageBreak.addOption(new Option("true", "Create page break"));
        this.add((Component)pageBreak);
    }

    protected ArticleSection createSection(FormSectionEvent event, MultiPartArticle article) {
        PageState state = event.getPageState();
        FormData data = event.getFormData();
        ArticleSection section = new ArticleSection();
        section.setTitle((String)data.get((Object)TITLE));
        section.setName(article.getName() + ": " + (String)data.get((Object)TITLE));
        return section;
    }

    public void register(Page p) {
        super.register(p);
        p.addGlobalStateParam((ParameterModel)this.m_imageParam);
        p.addGlobalStateParam((ParameterModel)this.m_textParam);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class SectionProcessListener
    implements FormProcessListener {
        private SectionProcessListener() {
        }

        public void process(FormSectionEvent event) throws FormProcessException {
            String text;
            TextAsset textAsset;
            PageState state = event.getPageState();
            FormData data = event.getFormData();
            BigDecimal id = new BigDecimal(SectionEditForm.this.m_selArticle.getSelectedKey(state).toString());
            MultiPartArticle article = null;
            try {
                article = new MultiPartArticle(id);
            }
            catch (DataObjectNotFoundException ex) {
                throw new UncheckedWrapperException((Throwable)ex);
            }
            ArticleSection section = (ArticleSection)SectionEditForm.this.m_selSection.getSelectedObject(state);
            if (section == null) {
                section = SectionEditForm.this.createSection(event, article);
                article.addSection(section);
            }
            section.setTitle((String)data.get((Object)SectionEditForm.TITLE));
            Object[] pageBreakVal = (Object[])data.get((Object)SectionEditForm.PAGE_BREAK);
            boolean pageBreak = pageBreakVal != null && pageBreakVal.length != 0 && "true".equals(pageBreakVal[0]);
            section.setPageBreak(pageBreak);
            ImageAsset imageAsset = SectionEditForm.this.m_imageUpload.processImageUpload(event);
            if (imageAsset != null) {
                section.setImage(imageAsset);
                SectionEditForm.this.m_selImage.setSelectedObject(state, (DomainObject)imageAsset);
            }
            if ((textAsset = (TextAsset)SectionEditForm.this.m_selText.getSelectedObject(state)) == null) {
                textAsset = new TextAsset();
                textAsset.setName(section.getName() + " text");
                SectionEditForm.this.m_selText.setSelectedObject(state, (DomainObject)textAsset);
                section.setText(textAsset);
            }
            if ((text = (String)data.get((Object)SectionEditForm.TEXT)) == null) {
                text = "";
            }
            textAsset.setText(text);
            if (SectionEditForm.this.m_container != null) {
                SectionEditForm.this.m_container.onlyShowComponent(state, "sec_tbl" + SectionEditForm.this.m_container.getTypeIDStr());
            }
        }
    }

    private class SectionSubmissionListener
    implements FormSubmissionListener {
        private SectionSubmissionListener() {
        }

        public void submitted(FormSectionEvent event) throws FormProcessException {
            PageState state = event.getPageState();
            if (SectionEditForm.this.m_saveCancelSection.getCancelButton().isSelected(state) && SectionEditForm.this.m_container != null) {
                SectionEditForm.this.m_container.onlyShowComponent(state, "sec_tbl" + SectionEditForm.this.m_container.getTypeIDStr());
                throw new FormProcessException((String)MPArticleGlobalizationUtil.globalize("cms.contenttypes.ui.mparticle.submission_cancelled").localize());
            }
        }
    }

    private class SectionInitListener
    implements FormInitListener {
        private SectionInitListener() {
        }

        public void init(FormSectionEvent event) throws FormProcessException {
            PageState state = event.getPageState();
            FormData data = event.getFormData();
            SectionEditForm.this.m_selImage.setSelectedObject(state, null);
            SectionEditForm.this.m_selText.setSelectedObject(state, null);
            if (SectionEditForm.this.m_selSection.getSelectedKey(state) != null) {
                BigDecimal id = new BigDecimal(SectionEditForm.this.m_selSection.getSelectedKey(state).toString());
                try {
                    ImageAsset img;
                    ArticleSection section = new ArticleSection(id);
                    data.put((Object)SectionEditForm.TITLE, (Object)section.getTitle());
                    TextAsset t = section.getText();
                    if (t != null) {
                        SectionEditForm.this.m_selText.setSelectedObject(state, (DomainObject)t);
                        data.put((Object)SectionEditForm.TEXT, (Object)t.getText());
                    }
                    if ((img = section.getImage()) != null) {
                        SectionEditForm.this.m_selImage.setSelectedObject(state, (DomainObject)img);
                    }
                    if (section.isPageBreak()) {
                        data.put((Object)SectionEditForm.PAGE_BREAK, (Object)new Object[]{"true"});
                    }
                }
                catch (DataObjectNotFoundException ex) {
                    log.error((Object)("Section(" + id + ") could not be found"));
                }
            }
            SectionEditForm.this.m_imageUpload.initImageUpload(event);
        }
    }
}

