/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui.mparticle;

import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SaveCancelSection;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormValidationListener;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.DateParameter;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.TrimmedStringParameter;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.contenttypes.MultiPartArticle;
import com.arsdigita.cms.contenttypes.util.MPArticleGlobalizationUtil;
import com.arsdigita.cms.ui.authoring.NameValidationListener;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.Assert;
import com.arsdigita.xml.Element;
import java.util.Date;
import javax.servlet.ServletException;
import org.apache.log4j.Logger;

public abstract class MultiPartArticleForm
extends FormSection
implements FormInitListener,
FormProcessListener,
FormValidationListener {
    protected ItemSelectionModel m_itemModel;
    protected SaveCancelSection m_saveCancelSection;
    public static final String NAME = "name";
    public static final String TITLE = "title";
    public static final String SUMMARY = "summary";
    public static final String LAUNCH_DATE = "launchDate";
    public static final String LANGUAGE = "language";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$contenttypes$ui$mparticle$MultiPartArticleForm == null ? (class$com$arsdigita$cms$contenttypes$ui$mparticle$MultiPartArticleForm = MultiPartArticleForm.class$("com.arsdigita.cms.contenttypes.ui.mparticle.MultiPartArticleForm")) : class$com$arsdigita$cms$contenttypes$ui$mparticle$MultiPartArticleForm));
    private Label m_script = new Label("<script language=\"javascript\">\n    var defaulting = false;\n\n    function urlize(title) {\n        var result = \"\";\n        for (var i = 0; i < title.length; i++) {\n            result = result + substitute(title.charAt(i));\n        }\n        return escape(result);\n    }\n\n    function substitute(c) {\n        switch (c) {\n            case \" \":\n                return \"-\";\n            case \"'\":\n            case \",\":\n            case \":\":\n            case \";\":\n            case \"?\":\n            case \"!\":\n                return \"\";\n            default:\n                return c.toLowerCase();\n        }\n    }\n</script>", false);
    static /* synthetic */ Class class$com$arsdigita$cms$contenttypes$ui$mparticle$MultiPartArticleForm;
    static /* synthetic */ Class class$com$arsdigita$cms$ItemSelectionModel;

    public MultiPartArticleForm(String formName, ItemSelectionModel itemModel) {
        super((Container)new ColumnPanel(2));
        this.m_itemModel = itemModel;
        ColumnPanel panel = (ColumnPanel)this.getPanel();
        panel.setBorder(false);
        panel.setPadColor("#FFFFFF");
        panel.setColumnWidth(1, "20%");
        panel.setColumnWidth(2, "80%");
        panel.setWidth("100%");
        this.addWidgets();
        this.addSaveCancelSection();
        this.addInitListener(this);
        this.addProcessListener(this);
        this.addValidationListener(this);
    }

    public void addSaveCancelSection() {
        this.m_saveCancelSection = new SaveCancelSection();
        this.add((Component)this.m_saveCancelSection, 65);
    }

    public SaveCancelSection getSaveCancelSection() {
        return this.m_saveCancelSection;
    }

    protected void addWidgets() {
        this.add((Component)new Label(MPArticleGlobalizationUtil.globalize("cms.contenttypes.ui.mparticle.title")));
        TextField titleWidget = new TextField((ParameterModel)new TrimmedStringParameter(TITLE));
        titleWidget.addValidationListener((ParameterListener)new NotNullValidationListener());
        titleWidget.setOnFocus("if (this.form.name.value == '') {  defaulting = true; this.form.name.value = urlize(this.value); }");
        titleWidget.setOnKeyUp("if (defaulting) { this.form.name.value = urlize(this.value) }");
        this.add((Component)titleWidget);
        this.add((Component)new Label(MPArticleGlobalizationUtil.globalize("cms.contenttypes.ui.mparticle.name")));
        TextField nameWidget = new TextField((ParameterModel)new TrimmedStringParameter(NAME));
        nameWidget.addValidationListener((ParameterListener)new NameValidationListener());
        nameWidget.setOnFocus("defaulting = false");
        nameWidget.setOnBlur("if (this.value == '') { defaulting = true; this.value = urlize(this.form.title.value) }");
        this.add((Component)nameWidget);
        if (!ContentSection.getConfig().getHideLaunchDate()) {
            this.add((Component)new Label(MPArticleGlobalizationUtil.globalize("cms.ui.authoring.page_launch_date")));
            DateParameter launchDateParam = new DateParameter(LAUNCH_DATE);
            com.arsdigita.bebop.form.Date launchDate = new com.arsdigita.bebop.form.Date((ParameterModel)launchDateParam);
            this.add((Component)launchDate);
        }
        this.add((Component)new Label(MPArticleGlobalizationUtil.globalize("cms.contenttypes.ui.mparticle.summary")));
        TextArea summaryWidget = new TextArea((ParameterModel)new TrimmedStringParameter(SUMMARY));
        summaryWidget.addValidationListener((ParameterListener)new NotNullValidationListener());
        summaryWidget.setRows(5);
        summaryWidget.setCols(30);
        this.add((Component)summaryWidget);
    }

    public abstract void init(FormSectionEvent var1) throws FormProcessException;

    public abstract void process(FormSectionEvent var1) throws FormProcessException;

    public abstract void validate(FormSectionEvent var1) throws FormProcessException;

    public MultiPartArticle initBasicWidgets(FormSectionEvent e) {
        Assert.exists((Object)this.m_itemModel, (Class)(class$com$arsdigita$cms$ItemSelectionModel == null ? (class$com$arsdigita$cms$ItemSelectionModel = MultiPartArticleForm.class$("com.arsdigita.cms.ItemSelectionModel")) : class$com$arsdigita$cms$ItemSelectionModel));
        FormData data = e.getFormData();
        PageState state = e.getPageState();
        MultiPartArticle article = (MultiPartArticle)this.m_itemModel.getSelectedObject(state);
        if (article != null) {
            data.put((Object)NAME, (Object)article.getName());
            data.put((Object)TITLE, (Object)article.getTitle());
            if (!ContentSection.getConfig().getHideLaunchDate()) {
                data.put((Object)LAUNCH_DATE, (Object)article.getLaunchDate());
            }
            data.put((Object)SUMMARY, (Object)article.getSummary());
        }
        return article;
    }

    public MultiPartArticle processBasicWidgets(FormSectionEvent e) {
        Assert.exists((Object)this.m_itemModel, (Class)(class$com$arsdigita$cms$ItemSelectionModel == null ? (class$com$arsdigita$cms$ItemSelectionModel = MultiPartArticleForm.class$("com.arsdigita.cms.ItemSelectionModel")) : class$com$arsdigita$cms$ItemSelectionModel));
        FormData data = e.getFormData();
        PageState state = e.getPageState();
        MultiPartArticle article = (MultiPartArticle)this.m_itemModel.getSelectedObject(state);
        if (article != null) {
            article.setName((String)data.get((Object)NAME));
            article.setTitle((String)data.get((Object)TITLE));
            if (!ContentSection.getConfig().getHideLaunchDate()) {
                article.setLaunchDate((Date)data.get((Object)LAUNCH_DATE));
            }
            article.setSummary((String)data.get((Object)SUMMARY));
        }
        return article;
    }

    public boolean validateNameUniqueness(Folder folder, FormSectionEvent event) {
        FormData data = event.getFormData();
        String name = (String)data.get((Object)NAME);
        if (name != null) {
            String query = "com.arsdigita.cms.validateUniqueItemName";
            DataQuery dq = SessionManager.getSession().retrieveQuery("com.arsdigita.cms.validateUniqueItemName");
            dq.setParameter("parentId", (Object)folder.getID());
            dq.setParameter(NAME, (Object)name);
            return dq.size() == 0L;
        }
        return false;
    }

    public MultiPartArticle createArticle(PageState state) throws FormProcessException {
        Assert.exists((Object)this.m_itemModel, (Class)(class$com$arsdigita$cms$ItemSelectionModel == null ? (class$com$arsdigita$cms$ItemSelectionModel = MultiPartArticleForm.class$("com.arsdigita.cms.ItemSelectionModel")) : class$com$arsdigita$cms$ItemSelectionModel));
        MultiPartArticle article = null;
        try {
            article = (MultiPartArticle)this.m_itemModel.createItem();
        }
        catch (ServletException e) {
            s_log.error((Object)("Servlet Exception: " + e.getMessage()), (Throwable)e);
            throw new FormProcessException(e.getMessage(), (Throwable)e);
        }
        if (this.m_itemModel.getSelectedKey(state) == null) {
            this.m_itemModel.setSelectedObject(state, (DomainObject)article);
        }
        return article;
    }

    public void generateXML(PageState ps, Element parent) {
        this.m_script.generateXML(ps, parent);
        super.generateXML(ps, parent);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

