/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes;

import com.arsdigita.cms.ContentPage;
import com.arsdigita.cms.contenttypes.ArticleSection;
import com.arsdigita.cms.contenttypes.ArticleSectionCollection;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataAssociationCursor;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.Assert;
import com.arsdigita.util.StringUtils;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class MultiPartArticle
extends ContentPage {
    private static final Logger log = Logger.getLogger((Class)(class$com$arsdigita$cms$contenttypes$MultiPartArticle == null ? (class$com$arsdigita$cms$contenttypes$MultiPartArticle = MultiPartArticle.class$("com.arsdigita.cms.contenttypes.MultiPartArticle")) : class$com$arsdigita$cms$contenttypes$MultiPartArticle));
    public static final String SUMMARY = "summary";
    public static final String SECTIONS = "sections";
    public static final int UP = 1;
    public static final int DOWN = 2;
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.contenttypes.MultiPartArticle";
    public static final String RANK = "rank";
    public static final String ARTICLE = "article";
    public static final String SECTION = "section";
    public static final int SUMMARY_LENGTH = 200;
    static /* synthetic */ Class class$com$arsdigita$cms$contenttypes$MultiPartArticle;
    static /* synthetic */ Class class$com$arsdigita$cms$ContentType;

    public MultiPartArticle() {
        super(BASE_DATA_OBJECT_TYPE);
    }

    public MultiPartArticle(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public MultiPartArticle(OID id) throws DataObjectNotFoundException {
        super(id);
    }

    public MultiPartArticle(DataObject obj) {
        super(obj);
    }

    public MultiPartArticle(String type) {
        super(type);
    }

    public void beforeSave() {
        super.beforeSave();
        Assert.exists((Object)this.getContentType(), (Class)(class$com$arsdigita$cms$ContentType == null ? (class$com$arsdigita$cms$ContentType = MultiPartArticle.class$("com.arsdigita.cms.ContentType")) : class$com$arsdigita$cms$ContentType));
    }

    public String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public String getSummary() {
        return (String)this.get(SUMMARY);
    }

    public void setSummary(String summary) {
        this.set(SUMMARY, summary);
    }

    public void addSection(ArticleSection section) {
        this.addSection(section, this.getMaxRank() + 1);
    }

    public void addSection(ArticleSection section, Integer rank) {
        log.info((Object)("adding section:" + section.getName() + " with rank " + rank.toString()));
        section.setRank(rank);
        this.add(SECTIONS, (DomainObject)section);
    }

    public void addSection(ArticleSection section, int rank) {
        this.addSection(section, new Integer(rank));
    }

    private ArticleSectionCollection getSections(boolean asc) {
        DataAssociationCursor dac = ((DataAssociation)this.get(SECTIONS)).cursor();
        String direction = asc ? " asc" : " desc";
        dac.addOrder(RANK + direction);
        return new ArticleSectionCollection((DataCollection)dac);
    }

    public ArticleSectionCollection getSections() {
        return this.getSections(true);
    }

    public void removeSection(ArticleSection section) {
        this.changeSectionRank(section, this.getMaxRank());
        section.delete();
    }

    public void changeSectionRank(BigDecimal sectionID, int rank) {
        ArticleSection target = (ArticleSection)DomainObjectFactory.newInstance((OID)new OID("com.arsdigita.cms.contenttypes.ArticleSection", (Object)sectionID));
        this.changeSectionRank(target, rank);
    }

    public void changeSectionRank(BigDecimal sectionID, BigDecimal dest) {
        int rank = this.getRank(dest);
        this.changeSectionRank(sectionID, rank);
    }

    public void changeSectionRank(ArticleSection section, BigDecimal dest) {
        int rank = this.getRank(dest);
        this.changeSectionRank(section, rank);
    }

    protected int getRank(BigDecimal sectionID) {
        try {
            ArticleSection section = new ArticleSection(sectionID);
            return section.getRank();
        }
        catch (DataObjectNotFoundException e) {
            throw new UncheckedWrapperException((Throwable)e);
        }
    }

    public void changeSectionRank(ArticleSection source, int destRank) {
        Integer r;
        if (log.isDebugEnabled()) {
            log.debug((Object)("*** changeSectionRank, section ID = " + source.getID() + "destRank = " + destRank));
        }
        if ((r = source.getRank()) == null) {
            throw new IllegalStateException((Object)((Object)source) + " has null rank");
        }
        int curRank = r;
        ArticleSectionCollection coll = this.getSections(true);
        if (curRank > destRank) {
            coll.setRange(new Integer(destRank), new Integer(curRank));
            int rank = destRank;
            while (coll.next()) {
                ArticleSection cur = coll.getArticleSection();
                cur.setRank(new Integer(rank + 1));
                ++rank;
            }
            source.setRank(new Integer(destRank));
        } else if (curRank < destRank) {
            coll.setRange(new Integer(curRank + 1), new Integer(destRank + 1));
            int rank = curRank + 1;
            while (coll.next()) {
                ArticleSection cur = coll.getArticleSection();
                cur.setRank(new Integer(rank - 1));
                ++rank;
            }
            source.setRank(new Integer(destRank));
        }
        coll.close();
    }

    protected int getMaxRank() {
        int rank;
        ArticleSectionCollection coll = this.getSections(false);
        if (coll.next()) {
            rank = coll.getArticleSection().getRank();
            coll.close();
        } else {
            rank = 0;
        }
        return rank;
    }

    public String getSearchSummary() {
        String summary = this.getSummary();
        if (summary == null) {
            return "";
        }
        return StringUtils.truncateString((String)summary, (int)200, (boolean)true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

