/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.contenttypes;

import com.arsdigita.cms.*;
import com.arsdigita.cms.contenttypes.AbstractContentTypeLoader;
import com.arsdigita.cms.lifecycle.*;
import com.arsdigita.cms.workflow.*;
import com.arsdigita.util.*;
import com.arsdigita.workflow.simple.*;

import com.arsdigita.util.parameter.Parameter;
import com.arsdigita.util.parameter.URLParameter;

import java.io.InputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.MalformedURLException;
import java.util.Date;

/**
 * Loader.
 *
 * @author Justin Ross &lt;jross@redhat.com&gt;
 * @version $Id: //cms/content-types/mparticle/dev/src/com/arsdigita/cms/contenttypes/MultiPartArticleLoader.java#9 $
 */
public class MultiPartArticleLoader extends AbstractContentTypeLoader {
    public final static String versionId =
        "$Id: //cms/content-types/mparticle/dev/src/com/arsdigita/cms/contenttypes/MultiPartArticleLoader.java#9 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static final String[] TYPES = {
        "/WEB-INF/content-types/com/arsdigita/cms/contenttypes/MultiPartArticle.xml"
    };

    public String[] getTypes() {
        return TYPES;
    }

    
    private URLParameter m_template;

    public MultiPartArticleLoader() {
        try {
            m_template = new URLParameter
                ("com.arsdigita.cms.contenttypes.mparticle.template", 
                 Parameter.REQUIRED,
                 new URL(null,
                         "resource:///WEB-INF/content-types/com/arsdigita/cms/contenttypes" +
                         "/mparticle-item.jsp"));
        } catch (MalformedURLException ex) {
            throw new UncheckedWrapperException("cannot parse url", ex);
        }

        register(m_template);
    }

    protected void prepareSection(final ContentSection section,
                                  final ContentType type,
                                  final LifecycleDefinition ld,
                                  final WorkflowTemplate wf) {
        super.prepareSection(section, type, ld, wf);

        setDefaultTemplate("MultiPartArticle-mparticle-item",
                           "mparticle-item",
                           (URL)get(m_template),
                           section, type,ld, wf);

    }
}
