/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui.mparticle;

import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.form.FileUpload;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.cms.ImageAsset;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.contenttypes.util.MPArticleGlobalizationUtil;
import com.arsdigita.cms.ui.ImageDisplay;
import com.arsdigita.dispatcher.MultipartHttpServletRequest;
import java.io.File;
import org.apache.log4j.Logger;

public class ImageUploadSection
extends FormSection {
    private static final Logger log = Logger.getLogger((Class)(class$com$arsdigita$cms$contenttypes$ui$mparticle$ImageUploadSection == null ? (class$com$arsdigita$cms$contenttypes$ui$mparticle$ImageUploadSection = ImageUploadSection.class$("com.arsdigita.cms.contenttypes.ui.mparticle.ImageUploadSection")) : class$com$arsdigita$cms$contenttypes$ui$mparticle$ImageUploadSection));
    public static final String IMAGE = "Image";
    public static final String CAPTION = "Caption";
    private String m_name;
    private ItemSelectionModel m_selImage;
    private ImageDisplay m_imageDisplay;
    private Label m_currentImage;
    static /* synthetic */ Class class$com$arsdigita$cms$contenttypes$ui$mparticle$ImageUploadSection;

    public ImageUploadSection(String name, ItemSelectionModel selImage, Container panel) {
        super(panel);
        this.m_selImage = selImage;
        this.m_name = name;
        this.m_imageDisplay = new ImageDisplay(this.m_selImage);
        this.m_imageDisplay.setClassAttr("MPAImageDisplay");
        this.m_currentImage = new Label(MPArticleGlobalizationUtil.globalize("cms.contenttypes.ui.mparticle.current_image"));
        this.add((Component)this.m_currentImage);
        this.add((Component)this.m_imageDisplay);
        this.add((Component)new Label(MPArticleGlobalizationUtil.globalize("cms.contenttypes.ui.mparticle.select_image")));
        this.add((Component)new FileUpload(this.m_name + IMAGE));
        this.add((Component)new Label(MPArticleGlobalizationUtil.globalize("cms.contenttypes.ui.mparticle.caption")));
        TextField caption = new TextField(this.m_name + CAPTION);
        caption.setSize(40);
        this.add((Component)caption);
    }

    public ImageUploadSection(String name, ItemSelectionModel selImage) {
        this(name, selImage, (Container)new ColumnPanel(2, true));
        ColumnPanel panel = (ColumnPanel)this.getPanel();
        panel.setBorder(false);
        panel.setPadColor("#FFFFFF");
        panel.setColumnWidth(1, "20%");
        panel.setColumnWidth(2, "80%");
    }

    public void initImageUpload(FormSectionEvent event) {
        FormData data = event.getFormData();
        PageState state = event.getPageState();
        ImageAsset image = (ImageAsset)this.m_selImage.getSelectedObject(state);
        this.m_currentImage.setVisible(state, false);
        this.m_imageDisplay.setVisible(state, false);
        if (image != null) {
            data.put((Object)(this.m_name + CAPTION), (Object)image.getDescription());
            this.m_currentImage.setVisible(state, true);
            this.m_imageDisplay.setVisible(state, true);
        }
    }

    public String getImageFilename(FormSectionEvent event) {
        FormData data = event.getFormData();
        return (String)data.get((Object)(this.m_name + IMAGE));
    }

    public File getImage(FormSectionEvent event) {
        FormData data = event.getFormData();
        String filename = this.getImageFilename(event);
        File image = null;
        if (filename != null && filename.length() > 0) {
            image = ((MultipartHttpServletRequest)event.getPageState().getRequest()).getFile(this.m_name + IMAGE);
        }
        return image;
    }

    public ImageAsset processImageUpload(FormSectionEvent event) {
        ImageAsset a = null;
        FormData data = event.getFormData();
        File image = this.getImage(event);
        if (image != null) {
            try {
                a = new ImageAsset();
                a.loadFromFile(this.getImageFilename(event), image, "image/jpeg");
                a.setDescription((String)data.get((Object)(this.m_name + CAPTION)));
            }
            catch (Exception ex) {
                log.error((Object)("Could not load " + this.getImageFilename(event)));
                return null;
            }
        }
        return a;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

