/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.contenttypes.ui.authoring;

import com.arsdigita.cms.contenttypes.MOTDItem;
import com.arsdigita.cms.contenttypes.util.MOTDGlobalizationUtil;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.ui.authoring.SimpleEditStep;
import com.arsdigita.cms.ui.authoring.AuthoringKitWizard;
import com.arsdigita.cms.ui.authoring.BasicPageForm;
import com.arsdigita.toolbox.ui.DomainObjectPropertySheet;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.parameters.StringLengthValidationListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;

/*
 * Form to edit MOTDItem.
 *
 * @author Aingaran Pillai
 * @see com.arsdigita.cms.contenttypes.MOTDItem
 * @version $Revision: #5 $
 */
public class MOTDItemPropertiesStep extends SimpleEditStep {

    public static String EDIT_SHEET_NAME = "edit";

    public MOTDItemPropertiesStep(ItemSelectionModel itemModel,
                                  AuthoringKitWizard parent) {

        super(itemModel, parent);
        
        BasicPageForm editSheet;
        editSheet = new MOTDItemPropertyForm(itemModel);
        add(EDIT_SHEET_NAME, "Edit", editSheet,
            editSheet.getSaveCancelSection().getCancelButton());

        setDisplayComponent(getMOTDDomainObjectPropertySheet(itemModel));
    }

    public static Component getMOTDDomainObjectPropertySheet
        (ItemSelectionModel itemModel) {

        DomainObjectPropertySheet sheet = new DomainObjectPropertySheet(itemModel);
        sheet.add(MOTDGlobalizationUtil.globalize("cms.ui.authoring.name_url"), MOTDItem.NAME);
        sheet.add(MOTDGlobalizationUtil.globalize("cms.ui.authoring.page_title"), MOTDItem.TITLE);
        sheet.add(MOTDGlobalizationUtil.globalize("cms.contenttypes.ui.motd.message"), MOTDItem.MESSAGE);

        return sheet;
    }

    private class MOTDItemPropertyForm extends BasicPageForm
        implements FormProcessListener, FormInitListener, FormSubmissionListener {

        public static final String ID = "motd_item_edit";
        public static final String MESSAGE = "message";

        public MOTDItemPropertyForm(ItemSelectionModel itemModel) {
            super(ID, itemModel);
        }

        protected void addWidgets() {
            super.addWidgets();

            TextArea msg = new TextArea(MESSAGE);
            msg.addValidationListener(new NotNullValidationListener());
            msg.addValidationListener(new StringLengthValidationListener
                (MOTDItem.MESSAGE_LENGTH));
            msg.setCols(40);
            msg.setRows(5);
            
            add(new Label(MOTDGlobalizationUtil.globalize("cms.contenttypes.ui.motd.message")));
            add(msg);
        }

        public void init(FormSectionEvent e) throws FormProcessException {
            
            FormData data = e.getFormData();
            MOTDItem item = (MOTDItem) super.initBasicWidgets(e);
            data.put(MESSAGE, item.getMessage());
        }

        public void submitted(FormSectionEvent e) throws FormProcessException {
            
            if (getSaveCancelSection().getSaveButton()
                .isSelected(e.getPageState())) {
                throw new FormProcessException((String)MOTDGlobalizationUtil.globalize("cms.ui.submission_cancelled").localize());
            }
        }

        public void process(FormSectionEvent e) throws FormProcessException {

            FormData data = e.getFormData();
            MOTDItem item = (MOTDItem) super.processBasicWidgets(e);

            if (item != null) {
                item.setMessage((String) data.get(MESSAGE));
                item.save();
            }
        }
    }

}



