/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.cms.contenttypes.MOTDItem;
import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.bebop.PageState;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.PersistenceException;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.xml.Element;

import java.math.BigDecimal;

/**
 * Displays most recent MOTD
 *
 * @author <a href="mailto:scott@arsdigita.com">Scott Seago</a>
 * @version $Id: //cms/content-types/motditem/dev/src/com/arsdigita/cms/contenttypes/ui/MOTDComponent.java#4 $
 *
 */

public class MOTDComponent extends SimpleComponent {

    public final static String BEBOP_XML_NS = 
        "http://www.arsdigita.com/bebop/1.0";
    
    public MOTDComponent() {
        super();
    }

    /**
     * Generate XML for the domain object supplied by the
     * selection model.
     */
    public void generateXML(PageState state, Element parent) {

        Element messages = new Element("bebop:motd", BEBOP_XML_NS);
        messages.addAttribute("id", getIdAttr());

        String categoryID = state.getRequest().getParameter("categoryID");
      
        if ( categoryID == null ) {
            try {
                DataCollection motds = 
                    SessionManager.getSession().retrieve(MOTDItem.BASE_DATA_OBJECT_TYPE);
                motds.addFilter("version = 'live'");
                motds.addOrder("id desc");
              
                MOTDItem msg;

                while (motds.next()) {                    
                    
                    msg = new MOTDItem(motds.getDataObject());

                    Element aMsg = new Element("bebop:message", BEBOP_XML_NS);
                    aMsg.addAttribute("id", msg.getID().toString());
                    aMsg.addAttribute("title", msg.getTitle());
                    aMsg.addAttribute("message", msg.getMessage());
                    aMsg.addAttribute("pubDate", msg.getPublicationDate());

                    messages.addContent(aMsg);                    
                }
                parent.addContent(messages);

                motds.close();

            } catch (PersistenceException ex) {
                //
            }
        }
    }
}


