/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui.authoring;

import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.cms.BinaryAsset;
import com.arsdigita.cms.FileAsset;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.contenttypes.MOTDItem;
import com.arsdigita.cms.contenttypes.util.MOTDGlobalizationUtil;
import com.arsdigita.cms.dispatcher.Utilities;
import com.arsdigita.cms.ui.FileUploadSection;
import com.arsdigita.cms.ui.authoring.AuthoringKitWizard;
import com.arsdigita.cms.ui.authoring.BasicPageForm;
import com.arsdigita.cms.ui.authoring.SimpleEditStep;
import com.arsdigita.cms.ui.workflow.WorkflowLockedComponentAccess;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.kernel.ui.DomainObjectSelectionModel;
import com.arsdigita.mimetypes.MimeType;
import com.arsdigita.toolbox.ui.ComponentAccess;
import com.arsdigita.toolbox.ui.DomainObjectPropertySheet;
import com.arsdigita.web.URL;
import java.io.File;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;

public class MOTDItemFileEdit
extends SimpleEditStep {
    public MOTDItemFileEdit(ItemSelectionModel itemModel, AuthoringKitWizard parent) {
        super(itemModel, parent);
        FileEditForm form = new FileEditForm(itemModel);
        this.add("edit", "Edit", (ComponentAccess)new WorkflowLockedComponentAccess((Component)form, itemModel), form.getSaveCancelSection().getCancelButton());
        DomainObjectPropertySheet sheet = new DomainObjectPropertySheet((DomainObjectSelectionModel)itemModel);
        sheet.add(MOTDGlobalizationUtil.globalize("cms.contenttypes.ui.motd.file"), "file.name", new DomainObjectPropertySheet.AttributeFormatter(){

            public String format(DomainObject item, String attribute, PageState state) {
                MOTDItem motd = (MOTDItem)item;
                FileAsset asset = motd.getFile();
                if (asset != null) {
                    return "<a href=\"" + URL.there((HttpServletRequest)state.getRequest(), (String)Utilities.getAssetURL((BinaryAsset)asset)).getRequestURI() + "\" target=\"_blank\">" + asset.getDisplayName() + "</a>";
                }
                return (String)MOTDGlobalizationUtil.globalize("cms.ui.authoring.none").localize();
            }
        });
        this.setDisplayComponent((Component)sheet);
    }

    private class FileEditForm
    extends BasicPageForm
    implements FormProcessListener {
        private FileUploadSection m_fileUploadSection;

        public FileEditForm(ItemSelectionModel itemModel) {
            super("FileEdit", new ColumnPanel(2), itemModel);
            this.addWidgets();
            this.addProcessListener(this);
        }

        protected void addWidgets() {
            this.add((Component)new Label(MOTDGlobalizationUtil.globalize("cms.contenttypes.ui.motd.file")));
            this.add((Component)new Label(new PrintListener(this){
                private final /* synthetic */ FileEditForm this$1;
                {
                    this.this$1 = this$1;
                }

                public void prepare(PrintEvent e) {
                    PageState s = e.getPageState();
                    Label l = (Label)e.getTarget();
                    MOTDItem item = (MOTDItem)this.this$1.getItemSelectionModel().getSelectedObject(s);
                    FileAsset file = item.getFile();
                    if (file != null) {
                        l.setLabel(file.getName());
                    } else {
                        l.setLabel(MOTDGlobalizationUtil.globalize("cms.ui.none"));
                    }
                }
            }));
            this.m_fileUploadSection = new FileUploadSection(MOTDGlobalizationUtil.globalize("cms.ui.authoring.file_upload.file_type"), "", "");
            this.m_fileUploadSection.getFileUploadWidget().addValidationListener((ParameterListener)new NotNullValidationListener());
            this.add((Component)this.m_fileUploadSection);
            super.addSaveCancelSection();
        }

        public void init(FormSectionEvent e) throws FormProcessException {
        }

        public void process(FormSectionEvent e) throws FormProcessException {
            FormData data = e.getFormData();
            PageState s = e.getPageState();
            MOTDItem item = (MOTDItem)this.getItemSelectionModel().getSelectedObject(s);
            if (item != null) {
                try {
                    FileAsset file = new FileAsset();
                    String fileName = this.m_fileUploadSection.getFileName(e);
                    File uploadFile = this.m_fileUploadSection.getFile(e);
                    MimeType type = MimeType.guessMimeTypeFromFile((String)fileName);
                    String mimeType = null == type ? "text/plain" : type.getMimeType();
                    file.loadFromFile(fileName, uploadFile, mimeType);
                    file.save();
                    item.setFile(file);
                    item.save();
                }
                catch (IOException err) {
                    throw new RuntimeException(err.getMessage());
                }
            }
        }
    }
}

