/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui.authoring;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.StringLengthValidationListener;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.contenttypes.MOTDItem;
import com.arsdigita.cms.contenttypes.util.MOTDGlobalizationUtil;
import com.arsdigita.cms.ui.authoring.AuthoringKitWizard;
import com.arsdigita.cms.ui.authoring.BasicPageForm;
import com.arsdigita.cms.ui.authoring.SimpleEditStep;
import com.arsdigita.kernel.ui.DomainObjectSelectionModel;
import com.arsdigita.toolbox.ui.DomainObjectPropertySheet;

public class MOTDItemPropertiesStep
extends SimpleEditStep {
    public static String EDIT_SHEET_NAME = "edit";

    public MOTDItemPropertiesStep(ItemSelectionModel itemModel, AuthoringKitWizard parent) {
        super(itemModel, parent);
        MOTDItemPropertyForm editSheet = new MOTDItemPropertyForm(itemModel);
        this.add(EDIT_SHEET_NAME, "Edit", (FormSection)editSheet, editSheet.getSaveCancelSection().getCancelButton());
        this.setDisplayComponent(MOTDItemPropertiesStep.getMOTDDomainObjectPropertySheet(itemModel));
    }

    public static Component getMOTDDomainObjectPropertySheet(ItemSelectionModel itemModel) {
        DomainObjectPropertySheet sheet = new DomainObjectPropertySheet((DomainObjectSelectionModel)itemModel);
        sheet.add(MOTDGlobalizationUtil.globalize("cms.ui.authoring.name_url"), "name");
        sheet.add(MOTDGlobalizationUtil.globalize("cms.ui.authoring.page_title"), "title");
        sheet.add(MOTDGlobalizationUtil.globalize("cms.contenttypes.ui.motd.message"), "message");
        return sheet;
    }

    private class MOTDItemPropertyForm
    extends BasicPageForm
    implements FormProcessListener,
    FormInitListener,
    FormSubmissionListener {
        public static final String ID = "motd_item_edit";
        public static final String MESSAGE = "message";

        public MOTDItemPropertyForm(ItemSelectionModel itemModel) {
            super(ID, itemModel);
        }

        protected void addWidgets() {
            super.addWidgets();
            TextArea msg = new TextArea(MESSAGE);
            msg.addValidationListener((ParameterListener)new NotNullValidationListener());
            msg.addValidationListener((ParameterListener)new StringLengthValidationListener(4000));
            msg.setCols(40);
            msg.setRows(5);
            this.add((Component)new Label(MOTDGlobalizationUtil.globalize("cms.contenttypes.ui.motd.message")));
            this.add((Component)msg);
        }

        public void init(FormSectionEvent e) throws FormProcessException {
            FormData data = e.getFormData();
            MOTDItem item = (MOTDItem)super.initBasicWidgets(e);
            data.put((Object)MESSAGE, (Object)item.getMessage());
        }

        public void submitted(FormSectionEvent e) throws FormProcessException {
            if (this.getSaveCancelSection().getSaveButton().isSelected(e.getPageState())) {
                throw new FormProcessException((String)MOTDGlobalizationUtil.globalize("cms.ui.submission_cancelled").localize());
            }
        }

        public void process(FormSectionEvent e) throws FormProcessException {
            FormData data = e.getFormData();
            MOTDItem item = (MOTDItem)super.processBasicWidgets(e);
            if (item != null) {
                item.setMessage((String)data.get((Object)MESSAGE));
                item.save();
            }
        }
    }
}

