/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.contenttypes;


import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.TextAsset;
import com.arsdigita.cms.TextPage;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.util.Assert;
import org.apache.log4j.Logger;

import java.math.BigDecimal;

/**
 * This content type represents a legal notice.
 *
 * @version $Revision: #5 $ $Date: 2004/04/07 $
 **/
public class LegalNotice extends TextPage {

    /** PDL property name for government UID */
    public static final String GOVERNMENT_UID = "governmentUID";

    /** Data object type for this domain object */
    public static final String BASE_DATA_OBJECT_TYPE
        = "com.arsdigita.cms.contenttypes.LegalNotice";

    private static final Logger s_log = Logger.getLogger(LegalNotice.class);
    public LegalNotice() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    public LegalNotice(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, id));
    }

    public LegalNotice(OID id) throws DataObjectNotFoundException {
        super(id);
    }

    public LegalNotice(DataObject obj) {
        super(obj);
    }

    public LegalNotice(String type) {
        super(type);
    }

    public void beforeSave() {
        super.beforeSave();
        
        Assert.exists(getContentType(), ContentType.class);
    }

    /* accessors *****************************************************/
    public String getGovernmentUID() {
        return (String) get(GOVERNMENT_UID);
    }

    public void setGovernmentUID(String governmentUID) {
        set(GOVERNMENT_UID, governmentUID);
    }

    // Search stuff to allow the content type to be searchable
    public static final int SUMMARY_LENGTH = 200;

    public String getSearchSummary() {
        TextAsset ta = getTextAsset();

        if (ta != null) {
            return com.arsdigita.util.StringUtils.truncateString(ta.getText(),
                                                                 SUMMARY_LENGTH,
                                                                 true);
        } else {
            return "";
        }
    }

}
