/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.contenttypes;

import com.arsdigita.cms.ContentType;

import com.arsdigita.db.*;
import com.arsdigita.domain.xml.*;
import com.arsdigita.persistence.pdl.*;
import com.arsdigita.runtime.*;
import com.arsdigita.xml.*;

import org.apache.log4j.Logger;

/**
 * Initializer
 *
 * @author Rafael H. Schloming &lt;rhs@mit.edu&gt;
 * @version $Revision: #6 $ $Date: 2004/04/07 $
 **/

public class JobInitializer extends ContentTypeInitializer {

    public final static String versionId = "$Id: //cms/content-types/job/dev/src/com/arsdigita/cms/contenttypes/JobInitializer.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";


    public JobInitializer() {
        super("ccm-cms-types-job.pdl.mf", Job.BASE_DATA_OBJECT_TYPE);
    }

    public String getTraversalXML() {
        return "WEB-INF/traversal-adapters/com/arsdigita/cms/contenttypes/Job.xml";
    }

    public String[] getStylesheets() {
        return new String[] {"/static/content-types/com/arsdigita/cms/contenttypes/Job.xsl"};
    }


}
