/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.cms.contenttypes.GlossaryItem;
import com.arsdigita.cms.contenttypes.util.GlossaryGlobalizationUtil;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.ui.authoring.BasicPageForm;


/**
 * Form to edit the basic properties of an GlossaryItem. This form can be
 * extended to create forms for GlossaryItem subclasses.
 */
public class GlossaryItemPropertyForm
    extends BasicPageForm
    implements FormProcessListener, FormInitListener, FormSubmissionListener {

    private GlossaryItemPropertiesStep m_step;

    /** parameter names */
    public static final String DEFINITION = "definition";

    /** Name of this form */
    public static final String ID = "GlossaryItem_edit";

    /**
     * Creates a new form to edit the GlossaryItem object specified by the item
     * selection model passed in.
     *
     * @param itemModel The ItemSelectionModel to use to obtain the GlossaryItem to
     * work on
     **/
    public GlossaryItemPropertyForm( ItemSelectionModel itemModel ) {
        this(itemModel,null);
    }
    /**
     * Creates a new form to edit the GlossaryItem object specified by the item
     * selection model passed in.
     *
     * @param itemModel The ItemSelectionModel to use to obtain the GlossaryItem to
     * work on
     * @param step The GlossaryItemPropertiesStep which controls this form.
     **/
    public GlossaryItemPropertyForm( ItemSelectionModel itemModel, GlossaryItemPropertiesStep step ) {
        super( ID, itemModel );
        m_step = step;
        addSubmissionListener(this);
    }


    /**
     * Adds widgets to the form.
     */
    protected void addWidgets() {
        super.addWidgets();

        add( new Label(GlossaryGlobalizationUtil.globalize("cms.contenttypes.ui.glossary.definition") ));
        ParameterModel definitionParam
            = new StringParameter( DEFINITION );
        definitionParam
            .addParameterListener( new NotNullValidationListener() );
        TextArea definition = new TextArea( definitionParam );
        definition.setCols( 40 );
        definition.setRows( 5 );
        add( definition );

    }

    /** Form initialisation hook. Fills widgets with data. */
    public void init( FormSectionEvent fse ) {
        FormData data = fse.getFormData();
        GlossaryItem glossary_item
            = (GlossaryItem) super.initBasicWidgets( fse );

        data.put( DEFINITION, glossary_item.getDefinition() );
    }

    /** Cancels streamlined editing. */
    public void submitted( FormSectionEvent fse ) {
        if (m_step != null &&
            getSaveCancelSection().getCancelButton()
            .isSelected( fse.getPageState())) {
            m_step.cancelStreamlinedCreation(fse.getPageState());
        }
    }
 
    /** Form processing hook. Saves GlossaryItem object. */
    public void process( FormSectionEvent fse ) {
        FormData data = fse.getFormData();
        
        GlossaryItem glossary_item
            = (GlossaryItem) super.processBasicWidgets( fse );

        // save only if save button was pressed
        if( glossary_item != null
            && getSaveCancelSection().getSaveButton()
            .isSelected( fse.getPageState() ) ) {
            glossary_item.setDefinition( (String)
                                         data.get( DEFINITION ) );
            glossary_item.save();
        }
        if (m_step != null) {
            m_step.maybeForwardToNextStep(fse.getPageState());
        }
    }
}
