/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.contenttypes;

import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.ContentPage;
import com.arsdigita.util.Assert;

import java.math.BigDecimal;



/**
 * This content type represents a GlossaryItem.
 *
 * @version $Revision: #5 $ $Date: 2004/04/07 $
 */
public class GlossaryItem extends ContentPage {

    /** PDL property name for definition */
    public static final String DEFINITION = "definition";

    /** Data object type for this domain object */
    public static final String BASE_DATA_OBJECT_TYPE
        = "com.arsdigita.cms.contenttypes.GlossaryItem";

    public GlossaryItem() {
        this( BASE_DATA_OBJECT_TYPE );
    }

    public GlossaryItem( BigDecimal id )
        throws DataObjectNotFoundException {
        this( new OID( BASE_DATA_OBJECT_TYPE, id ) );
    }

    public GlossaryItem( OID id )
        throws DataObjectNotFoundException {
        super( id );
    }

    public GlossaryItem( DataObject obj ) {
        super( obj );
    }

    public GlossaryItem( String type ) {
        super( type );
    }


    public void beforeSave() {
        super.beforeSave();
        
        Assert.exists(getContentType(), ContentType.class);
    }

    /* accessors *****************************************************/
    public String getDefinition() {
        return (String) get( DEFINITION );
    }

    public void setDefinition( String definition ) {
        set( DEFINITION, definition );
    }

    // Search stuff to allow the content type to be searchable
    public String getSearchSummary() {
        return getDefinition();
    }

}
