/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.contenttypes.ui.authoring;

import com.arsdigita.cms.contenttypes.GlossaryItem;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.ui.authoring.PageCreate;
import com.arsdigita.cms.ui.authoring.CreationSelector;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.StringLengthValidationListener;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.PageState;
import com.arsdigita.kernel.KernelHelper;
import com.arsdigita.cms.contenttypes.util.GlossaryGlobalizationUtil;
import java.math.BigDecimal;
import java.lang.Exception;

/*
 * A page that will create a new GlossaryItem.
 * 
 * @author Dirk Gomez
 * @see com.arsdigita.intranet.cms.GlossaryItem
 * @version $Revision: #4 $
 */
public class GlossaryItemCreate extends PageCreate {

    public static final String DEFINITION = "definition";

    private CreationSelector m_parent;

    public GlossaryItemCreate(ItemSelectionModel itemModel,
                              CreationSelector parent) {

        super(itemModel, parent);
        m_parent = parent;
    }

    protected void addWidgets() {
        
        super.addWidgets();
        
        TextArea definition = new TextArea(DEFINITION);
        definition.addValidationListener(new NotNullValidationListener());
        definition.setCols(40);
        definition.setRows(5);

        add(new Label(GlossaryGlobalizationUtil.globalize("cms.contenttypes.ui.glossary.definition")));
        add(definition);
    }

    public void process(FormSectionEvent e) throws FormProcessException {

        FormData data = e.getFormData();
        PageState state = e.getPageState();
        ItemSelectionModel m = getItemSelectionModel();

        // Try to get the content section from the state parameter
        Folder f = m_parent.getFolder(state);
        ContentSection sec = m_parent.getContentSection(state);
        GlossaryItem item = (GlossaryItem)createContentPage(state);
        item.setLanguage((String) data.get(LANGUAGE));                        
        item.setName((String)data.get(NAME));
        item.setTitle((String)data.get(TITLE));
        item.setDefinition((String)data.get(DEFINITION));
        item.save();

        final ContentBundle bundle = new ContentBundle(item);
        bundle.setParent(f);
        bundle.setContentSection(m_parent.getContentSection(state));
        bundle.save();
        
        // Apply default workflow
        getWorkflowSection().applyWorkflow(state, item);
        
        // Start edititng the component right away
        m_parent.editItem(state, item);
    }
}
