/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.cms.contenttypes.GlossaryItem;
import com.arsdigita.cms.contenttypes.util.GlossaryGlobalizationUtil;
import com.arsdigita.bebop.Component;
import com.arsdigita.cms.ui.authoring.BasicPageForm;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.ui.authoring.AuthoringKitWizard;
import com.arsdigita.cms.ui.authoring.SimpleEditStep;
import com.arsdigita.toolbox.ui.DomainObjectPropertySheet;
import com.arsdigita.cms.ui.workflow.WorkflowLockedComponentAccess;


/**
 * Authoring step to edit the simple attributes of the GlossaryItem content 
 * type (and its subclasses). 
 */
public class GlossaryItemPropertiesStep
    extends SimpleEditStep {

    /** The name of the editing sheet added to this step */
    public static final String EDIT_SHEET_NAME = "edit";

    public GlossaryItemPropertiesStep( ItemSelectionModel itemModel,
                                       AuthoringKitWizard parent ) {
        super( itemModel, parent );

        setDefaultEditKey(EDIT_SHEET_NAME);
        BasicPageForm editSheet;

        editSheet = new GlossaryItemPropertyForm( itemModel, this);
        add( EDIT_SHEET_NAME, "Edit", 
             new WorkflowLockedComponentAccess(editSheet, itemModel),
             editSheet.getSaveCancelSection().getCancelButton() );

        setDisplayComponent( getGlossaryDomainObjectPropertySheet( itemModel ) );
    }

    /**
     * Returns a component that displays the properties of the 
     * GlossaryItem specified by the ItemSelectionModel passed in.
     * @param itemModel The ItemSelectionModel to use
     * @pre itemModel != null
     * @return A component to display the state of the basic properties
     *  of the release
     */
    public static Component getGlossaryDomainObjectPropertySheet( ItemSelectionModel
                                                          itemModel ) {
        DomainObjectPropertySheet sheet = new DomainObjectPropertySheet( itemModel );

        sheet.add(GlossaryGlobalizationUtil.globalize("cms.ui.authoring.name_url"), GlossaryItem.NAME );
        sheet.add(GlossaryGlobalizationUtil.globalize("cms.contenttypes.ui.glossary.term"), GlossaryItem.TITLE );
        sheet.add(GlossaryGlobalizationUtil.globalize("cms.contenttypes.ui.glossary.definition"), GlossaryItem.DEFINITION );

        return sheet;
    }
}
